/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.admins;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.admins.AsyncRawAdminsClient;
import com.intercom.api.resources.admins.requests.ConfigureAwayAdminRequest;
import com.intercom.api.resources.admins.requests.FindAdminRequest;
import com.intercom.api.resources.admins.requests.ListAllActivityLogsRequest;
import com.intercom.api.resources.admins.types.Admin;
import com.intercom.api.types.ActivityLogList;
import com.intercom.api.types.AdminList;
import com.intercom.api.types.AdminWithApp;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncAdminsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAdminsClient rawClient;

    public AsyncAdminsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAdminsClient(clientOptions);
    }

    public AsyncRawAdminsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Optional<AdminWithApp>> identify() {
        return this.rawClient.identify().thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<AdminWithApp>> identify(RequestOptions requestOptions) {
        return this.rawClient.identify(requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Admin>> away(ConfigureAwayAdminRequest request) {
        return this.rawClient.away(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Admin>> away(ConfigureAwayAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.away(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<ActivityLogList> listAllActivityLogs(ListAllActivityLogsRequest request) {
        return this.rawClient.listAllActivityLogs(request).thenApply(response -> (ActivityLogList)response.body());
    }

    public CompletableFuture<ActivityLogList> listAllActivityLogs(ListAllActivityLogsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAllActivityLogs(request, requestOptions).thenApply(response -> (ActivityLogList)response.body());
    }

    public CompletableFuture<AdminList> list() {
        return this.rawClient.list().thenApply(response -> (AdminList)response.body());
    }

    public CompletableFuture<AdminList> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (AdminList)response.body());
    }

    public CompletableFuture<Optional<Admin>> find(FindAdminRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Admin>> find(FindAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Optional)response.body());
    }
}

