/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.resources.contacts.AsyncRawContactsClient;
import com.intercom.api.resources.contacts.requests.ArchiveContactRequest;
import com.intercom.api.resources.contacts.requests.AttachSubscriptionToContactRequest;
import com.intercom.api.resources.contacts.requests.BlockContactRequest;
import com.intercom.api.resources.contacts.requests.DeleteContactRequest;
import com.intercom.api.resources.contacts.requests.DetachSubscriptionFromContactRequest;
import com.intercom.api.resources.contacts.requests.FindContactRequest;
import com.intercom.api.resources.contacts.requests.ListAttachedCompaniesRequest;
import com.intercom.api.resources.contacts.requests.ListAttachedSubscriptionsRequest;
import com.intercom.api.resources.contacts.requests.ListContactsRequest;
import com.intercom.api.resources.contacts.requests.ListSegmentsAttachedToContactRequest;
import com.intercom.api.resources.contacts.requests.ListTagsAttachedToContactRequest;
import com.intercom.api.resources.contacts.requests.MergeContactsRequest;
import com.intercom.api.resources.contacts.requests.ShowContactByExternalIdRequest;
import com.intercom.api.resources.contacts.requests.UnarchiveContactRequest;
import com.intercom.api.resources.contacts.requests.UpdateContactRequest;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.contacts.types.ContactsCreateResponse;
import com.intercom.api.resources.contacts.types.ContactsFindResponse;
import com.intercom.api.resources.contacts.types.ContactsMergeLeadInUserResponse;
import com.intercom.api.resources.contacts.types.ContactsUpdateResponse;
import com.intercom.api.resources.contacts.types.ShowContactByExternalIdResponse;
import com.intercom.api.resources.subscriptiontypes.types.SubscriptionType;
import com.intercom.api.types.ContactArchived;
import com.intercom.api.types.ContactBlocked;
import com.intercom.api.types.ContactDeleted;
import com.intercom.api.types.ContactSegments;
import com.intercom.api.types.ContactUnarchived;
import com.intercom.api.types.CreateContactRequest;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.SubscriptionTypeList;
import com.intercom.api.types.TagList;
import java.util.concurrent.CompletableFuture;

public class AsyncContactsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawContactsClient rawClient;

    public AsyncContactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawContactsClient(clientOptions);
    }

    public AsyncRawContactsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Company>> listAttachedCompanies(ListAttachedCompaniesRequest request) {
        return this.rawClient.listAttachedCompanies(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Company>> listAttachedCompanies(ListAttachedCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedCompanies(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<ContactSegments> listAttachedSegments(ListSegmentsAttachedToContactRequest request) {
        return this.rawClient.listAttachedSegments(request).thenApply(response -> (ContactSegments)response.body());
    }

    public CompletableFuture<ContactSegments> listAttachedSegments(ListSegmentsAttachedToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSegments(request, requestOptions).thenApply(response -> (ContactSegments)response.body());
    }

    public CompletableFuture<SubscriptionTypeList> listAttachedSubscriptions(ListAttachedSubscriptionsRequest request) {
        return this.rawClient.listAttachedSubscriptions(request).thenApply(response -> (SubscriptionTypeList)response.body());
    }

    public CompletableFuture<SubscriptionTypeList> listAttachedSubscriptions(ListAttachedSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSubscriptions(request, requestOptions).thenApply(response -> (SubscriptionTypeList)response.body());
    }

    public CompletableFuture<SubscriptionType> attachSubscription(AttachSubscriptionToContactRequest request) {
        return this.rawClient.attachSubscription(request).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<SubscriptionType> attachSubscription(AttachSubscriptionToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachSubscription(request, requestOptions).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<SubscriptionType> detachSubscription(DetachSubscriptionFromContactRequest request) {
        return this.rawClient.detachSubscription(request).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<SubscriptionType> detachSubscription(DetachSubscriptionFromContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachSubscription(request, requestOptions).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<TagList> listAttachedTags(ListTagsAttachedToContactRequest request) {
        return this.rawClient.listAttachedTags(request).thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<TagList> listAttachedTags(ListTagsAttachedToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedTags(request, requestOptions).thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<ContactsFindResponse> find(FindContactRequest request) {
        return this.rawClient.find(request).thenApply(response -> (ContactsFindResponse)response.body());
    }

    public CompletableFuture<ContactsFindResponse> find(FindContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (ContactsFindResponse)response.body());
    }

    public CompletableFuture<ContactsUpdateResponse> update(UpdateContactRequest request) {
        return this.rawClient.update(request).thenApply(response -> (ContactsUpdateResponse)response.body());
    }

    public CompletableFuture<ContactsUpdateResponse> update(UpdateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (ContactsUpdateResponse)response.body());
    }

    public CompletableFuture<ContactDeleted> delete(DeleteContactRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (ContactDeleted)response.body());
    }

    public CompletableFuture<ContactDeleted> delete(DeleteContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (ContactDeleted)response.body());
    }

    public CompletableFuture<ContactsMergeLeadInUserResponse> mergeLeadInUser() {
        return this.rawClient.mergeLeadInUser().thenApply(response -> (ContactsMergeLeadInUserResponse)response.body());
    }

    public CompletableFuture<ContactsMergeLeadInUserResponse> mergeLeadInUser(MergeContactsRequest request) {
        return this.rawClient.mergeLeadInUser(request).thenApply(response -> (ContactsMergeLeadInUserResponse)response.body());
    }

    public CompletableFuture<ContactsMergeLeadInUserResponse> mergeLeadInUser(MergeContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeLeadInUser(request, requestOptions).thenApply(response -> (ContactsMergeLeadInUserResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Contact>> search(SearchRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Contact>> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Contact>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Contact>> list(ListContactsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Contact>> list(ListContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<ContactsCreateResponse> create(CreateContactRequest request) {
        return this.rawClient.create(request).thenApply(response -> (ContactsCreateResponse)response.body());
    }

    public CompletableFuture<ContactsCreateResponse> create(CreateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (ContactsCreateResponse)response.body());
    }

    public CompletableFuture<ShowContactByExternalIdResponse> showContactByExternalId(ShowContactByExternalIdRequest request) {
        return this.rawClient.showContactByExternalId(request).thenApply(response -> (ShowContactByExternalIdResponse)response.body());
    }

    public CompletableFuture<ShowContactByExternalIdResponse> showContactByExternalId(ShowContactByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.showContactByExternalId(request, requestOptions).thenApply(response -> (ShowContactByExternalIdResponse)response.body());
    }

    public CompletableFuture<ContactArchived> archive(ArchiveContactRequest request) {
        return this.rawClient.archive(request).thenApply(response -> (ContactArchived)response.body());
    }

    public CompletableFuture<ContactArchived> archive(ArchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.archive(request, requestOptions).thenApply(response -> (ContactArchived)response.body());
    }

    public CompletableFuture<ContactUnarchived> unarchive(UnarchiveContactRequest request) {
        return this.rawClient.unarchive(request).thenApply(response -> (ContactUnarchived)response.body());
    }

    public CompletableFuture<ContactUnarchived> unarchive(UnarchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.unarchive(request, requestOptions).thenApply(response -> (ContactUnarchived)response.body());
    }

    public CompletableFuture<ContactBlocked> blockContact(BlockContactRequest request) {
        return this.rawClient.blockContact(request).thenApply(response -> (ContactBlocked)response.body());
    }

    public CompletableFuture<ContactBlocked> blockContact(BlockContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.blockContact(request, requestOptions).thenApply(response -> (ContactBlocked)response.body());
    }
}

