/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FindConversationRequest {
    private final String conversationId;
    private final Optional<String> displayAs;
    private final Optional<Boolean> includeTranslations;
    private final Map<String, Object> additionalProperties;

    private FindConversationRequest(String conversationId, Optional<String> displayAs, Optional<Boolean> includeTranslations, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.displayAs = displayAs;
        this.includeTranslations = includeTranslations;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="display_as")
    public Optional<String> getDisplayAs() {
        return this.displayAs;
    }

    @JsonProperty(value="include_translations")
    public Optional<Boolean> getIncludeTranslations() {
        return this.includeTranslations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FindConversationRequest && this.equalTo((FindConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindConversationRequest other) {
        return this.conversationId.equals(other.conversationId) && this.displayAs.equals(other.displayAs) && this.includeTranslations.equals(other.includeTranslations);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.displayAs, this.includeTranslations);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    _FinalStage {
        private String conversationId;
        private Optional<Boolean> includeTranslations = Optional.empty();
        private Optional<String> displayAs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FindConversationRequest other) {
            this.conversationId(other.getConversationId());
            this.displayAs(other.getDisplayAs());
            this.includeTranslations(other.getIncludeTranslations());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        public _FinalStage includeTranslations(Boolean includeTranslations) {
            this.includeTranslations = Optional.ofNullable(includeTranslations);
            return this;
        }

        @Override
        @JsonSetter(value="include_translations", nulls=Nulls.SKIP)
        public _FinalStage includeTranslations(Optional<Boolean> includeTranslations) {
            this.includeTranslations = includeTranslations;
            return this;
        }

        @Override
        public _FinalStage displayAs(String displayAs) {
            this.displayAs = Optional.ofNullable(displayAs);
            return this;
        }

        @Override
        @JsonSetter(value="display_as", nulls=Nulls.SKIP)
        public _FinalStage displayAs(Optional<String> displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public FindConversationRequest build() {
            return new FindConversationRequest(this.conversationId, this.displayAs, this.includeTranslations, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FindConversationRequest build();

        public _FinalStage displayAs(Optional<String> var1);

        public _FinalStage displayAs(String var1);

        public _FinalStage includeTranslations(Optional<Boolean> var1);

        public _FinalStage includeTranslations(Boolean var1);
    }

    public static interface ConversationIdStage {
        public _FinalStage conversationId(@NotNull String var1);

        public Builder from(FindConversationRequest var1);
    }
}

