/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.conversations.types.ConversationsManageRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ManageConversationPartsRequest {
    private final String conversationId;
    private final ConversationsManageRequestBody body;
    private final Map<String, Object> additionalProperties;

    private ManageConversationPartsRequest(String conversationId, ConversationsManageRequestBody body, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="body")
    public ConversationsManageRequestBody getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ManageConversationPartsRequest && this.equalTo((ManageConversationPartsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ManageConversationPartsRequest other) {
        return this.conversationId.equals(other.conversationId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    BodyStage,
    _FinalStage {
        private String conversationId;
        private ConversationsManageRequestBody body;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ManageConversationPartsRequest other) {
            this.conversationId(other.getConversationId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public BodyStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull ConversationsManageRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public ManageConversationPartsRequest build() {
            return new ManageConversationPartsRequest(this.conversationId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ManageConversationPartsRequest build();
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull ConversationsManageRequestBody var1);
    }

    public static interface ConversationIdStage {
        public BodyStage conversationId(@NotNull String var1);

        public Builder from(ManageConversationPartsRequest var1);
    }
}

