/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CustomObjectInstanceList;
import com.intercom.api.types.Datetime;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateConversationRequest {
    private final String conversationId;
    private final Optional<String> displayAs;
    private final Optional<Boolean> read;
    private final Optional<String> title;
    private final Optional<Map<String, CustomAttributesValue>> customAttributes;
    private final Optional<String> companyId;
    private final Map<String, Object> additionalProperties;

    private UpdateConversationRequest(String conversationId, Optional<String> displayAs, Optional<Boolean> read, Optional<String> title, Optional<Map<String, CustomAttributesValue>> customAttributes, Optional<String> companyId, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.displayAs = displayAs;
        this.read = read;
        this.title = title;
        this.customAttributes = customAttributes;
        this.companyId = companyId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="display_as")
    public Optional<String> getDisplayAs() {
        return this.displayAs;
    }

    @JsonProperty(value="read")
    public Optional<Boolean> getRead() {
        return this.read;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, CustomAttributesValue>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateConversationRequest && this.equalTo((UpdateConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateConversationRequest other) {
        return this.conversationId.equals(other.conversationId) && this.displayAs.equals(other.displayAs) && this.read.equals(other.read) && this.title.equals(other.title) && this.customAttributes.equals(other.customAttributes) && this.companyId.equals(other.companyId);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.displayAs, this.read, this.title, this.customAttributes, this.companyId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class CustomAttributesValue {
        private final Object value;
        private final int type;

        private CustomAttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((String)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((Integer)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((Datetime)this.value);
            }
            if (this.type == 3) {
                return visitor.visit((CustomObjectInstanceList)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CustomAttributesValue && this.equalTo((CustomAttributesValue)other);
        }

        private boolean equalTo(CustomAttributesValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static CustomAttributesValue of(String value) {
            return new CustomAttributesValue(value, 0);
        }

        public static CustomAttributesValue of(int value) {
            return new CustomAttributesValue(value, 1);
        }

        public static CustomAttributesValue of(Datetime value) {
            return new CustomAttributesValue(value, 2);
        }

        public static CustomAttributesValue of(CustomObjectInstanceList value) {
            return new CustomAttributesValue(value, 3);
        }

        static final class Deserializer
        extends StdDeserializer<CustomAttributesValue> {
            Deserializer() {
                super(CustomAttributesValue.class);
            }

            public CustomAttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return CustomAttributesValue.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                }
                catch (RuntimeException runtimeException) {
                    if (value instanceof Integer) {
                        return CustomAttributesValue.of((Integer)value);
                    }
                    try {
                        return CustomAttributesValue.of((Datetime)ObjectMappers.JSON_MAPPER.convertValue(value, Datetime.class));
                    }
                    catch (RuntimeException runtimeException2) {
                        try {
                            return CustomAttributesValue.of((CustomObjectInstanceList)ObjectMappers.JSON_MAPPER.convertValue(value, CustomObjectInstanceList.class));
                        }
                        catch (RuntimeException runtimeException3) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(String var1);

            public T visit(int var1);

            public T visit(Datetime var1);

            public T visit(CustomObjectInstanceList var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    _FinalStage {
        private String conversationId;
        private Optional<String> companyId = Optional.empty();
        private Optional<Map<String, CustomAttributesValue>> customAttributes = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<Boolean> read = Optional.empty();
        private Optional<String> displayAs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateConversationRequest other) {
            this.conversationId(other.getConversationId());
            this.displayAs(other.getDisplayAs());
            this.read(other.getRead());
            this.title(other.getTitle());
            this.customAttributes(other.getCustomAttributes());
            this.companyId(other.getCompanyId());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public _FinalStage customAttributes(Map<String, CustomAttributesValue> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, CustomAttributesValue>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public _FinalStage title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @Override
        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public _FinalStage title(Optional<String> title) {
            this.title = title;
            return this;
        }

        @Override
        public _FinalStage read(Boolean read) {
            this.read = Optional.ofNullable(read);
            return this;
        }

        @Override
        @JsonSetter(value="read", nulls=Nulls.SKIP)
        public _FinalStage read(Optional<Boolean> read) {
            this.read = read;
            return this;
        }

        @Override
        public _FinalStage displayAs(String displayAs) {
            this.displayAs = Optional.ofNullable(displayAs);
            return this;
        }

        @Override
        @JsonSetter(value="display_as", nulls=Nulls.SKIP)
        public _FinalStage displayAs(Optional<String> displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public UpdateConversationRequest build() {
            return new UpdateConversationRequest(this.conversationId, this.displayAs, this.read, this.title, this.customAttributes, this.companyId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateConversationRequest build();

        public _FinalStage displayAs(Optional<String> var1);

        public _FinalStage displayAs(String var1);

        public _FinalStage read(Optional<Boolean> var1);

        public _FinalStage read(Boolean var1);

        public _FinalStage title(Optional<String> var1);

        public _FinalStage title(String var1);

        public _FinalStage customAttributes(Optional<Map<String, CustomAttributesValue>> var1);

        public _FinalStage customAttributes(Map<String, CustomAttributesValue> var1);

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);
    }

    public static interface ConversationIdStage {
        public _FinalStage conversationId(@NotNull String var1);

        public Builder from(UpdateConversationRequest var1);
    }
}

