/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.customchannelevents;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.customchannelevents.AsyncRawCustomChannelEventsClient;
import com.intercom.api.resources.customchannelevents.requests.NotifyAttributeCollectedRequest;
import com.intercom.api.resources.customchannelevents.requests.NotifyNewMessageRequest;
import com.intercom.api.resources.customchannelevents.requests.NotifyQuickReplySelectedRequest;
import com.intercom.api.types.CustomChannelBaseEvent;
import com.intercom.api.types.CustomChannelNotificationResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomChannelEventsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomChannelEventsClient rawClient;

    public AsyncCustomChannelEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomChannelEventsClient(clientOptions);
    }

    public AsyncRawCustomChannelEventsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyNewConversation(CustomChannelBaseEvent request) {
        return this.rawClient.notifyNewConversation(request).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyNewConversation(CustomChannelBaseEvent request, RequestOptions requestOptions) {
        return this.rawClient.notifyNewConversation(request, requestOptions).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyNewMessage(NotifyNewMessageRequest request) {
        return this.rawClient.notifyNewMessage(request).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyNewMessage(NotifyNewMessageRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyNewMessage(request, requestOptions).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyQuickReplySelected(NotifyQuickReplySelectedRequest request) {
        return this.rawClient.notifyQuickReplySelected(request).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyQuickReplySelected(NotifyQuickReplySelectedRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyQuickReplySelected(request, requestOptions).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyAttributeCollected(NotifyAttributeCollectedRequest request) {
        return this.rawClient.notifyAttributeCollected(request).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }

    public CompletableFuture<CustomChannelNotificationResponse> notifyAttributeCollected(NotifyAttributeCollectedRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyAttributeCollected(request, requestOptions).thenApply(response -> (CustomChannelNotificationResponse)response.body());
    }
}

