/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.UpdateDataAttributeRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateDataAttributeRequest {
    private final int dataAttributeId;
    private final UpdateDataAttributeRequestBody body;
    private final Map<String, Object> additionalProperties;

    private UpdateDataAttributeRequest(int dataAttributeId, UpdateDataAttributeRequestBody body, Map<String, Object> additionalProperties) {
        this.dataAttributeId = dataAttributeId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="data_attribute_id")
    public int getDataAttributeId() {
        return this.dataAttributeId;
    }

    @JsonProperty(value="body")
    public UpdateDataAttributeRequestBody getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateDataAttributeRequest && this.equalTo((UpdateDataAttributeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateDataAttributeRequest other) {
        return this.dataAttributeId == other.dataAttributeId && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.dataAttributeId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DataAttributeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DataAttributeIdStage,
    BodyStage,
    _FinalStage {
        private int dataAttributeId;
        private UpdateDataAttributeRequestBody body;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateDataAttributeRequest other) {
            this.dataAttributeId(other.getDataAttributeId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="data_attribute_id")
        public BodyStage dataAttributeId(int dataAttributeId) {
            this.dataAttributeId = dataAttributeId;
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull UpdateDataAttributeRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public UpdateDataAttributeRequest build() {
            return new UpdateDataAttributeRequest(this.dataAttributeId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateDataAttributeRequest build();
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull UpdateDataAttributeRequestBody var1);
    }

    public static interface DataAttributeIdStage {
        public BodyStage dataAttributeId(int var1);

        public Builder from(UpdateDataAttributeRequest var1);
    }
}

