/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataexport.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExportReportingDataRequest {
    private final String jobIdentifier;
    private final String appId;
    private final String clientId;
    private final Map<String, Object> additionalProperties;

    private ExportReportingDataRequest(String jobIdentifier, String appId, String clientId, Map<String, Object> additionalProperties) {
        this.jobIdentifier = jobIdentifier;
        this.appId = appId;
        this.clientId = clientId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job_identifier")
    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    @JsonProperty(value="app_id")
    public String getAppId() {
        return this.appId;
    }

    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExportReportingDataRequest && this.equalTo((ExportReportingDataRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExportReportingDataRequest other) {
        return this.jobIdentifier.equals(other.jobIdentifier) && this.appId.equals(other.appId) && this.clientId.equals(other.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.appId, this.clientId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdentifierStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements JobIdentifierStage,
    AppIdStage,
    ClientIdStage,
    _FinalStage {
        private String jobIdentifier;
        private String appId;
        private String clientId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ExportReportingDataRequest other) {
            this.jobIdentifier(other.getJobIdentifier());
            this.appId(other.getAppId());
            this.clientId(other.getClientId());
            return this;
        }

        @Override
        @JsonSetter(value="job_identifier")
        public AppIdStage jobIdentifier(@NotNull String jobIdentifier) {
            this.jobIdentifier = Objects.requireNonNull(jobIdentifier, "jobIdentifier must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="app_id")
        public ClientIdStage appId(@NotNull String appId) {
            this.appId = Objects.requireNonNull(appId, "appId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="client_id")
        public _FinalStage clientId(@NotNull String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId must not be null");
            return this;
        }

        @Override
        public ExportReportingDataRequest build() {
            return new ExportReportingDataRequest(this.jobIdentifier, this.appId, this.clientId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ExportReportingDataRequest build();
    }

    public static interface ClientIdStage {
        public _FinalStage clientId(@NotNull String var1);
    }

    public static interface AppIdStage {
        public ClientIdStage appId(@NotNull String var1);
    }

    public static interface JobIdentifierStage {
        public AppIdStage jobIdentifier(@NotNull String var1);

        public Builder from(ExportReportingDataRequest var1);
    }
}

