/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.items;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.news.items.RawItemsClient;
import com.intercom.api.resources.news.items.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.news.items.requests.FindNewsItemRequest;
import com.intercom.api.resources.news.items.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.news.types.NewsItem;
import com.intercom.api.types.DeletedObject;
import com.intercom.api.types.NewsItemRequest;
import com.intercom.api.types.PaginatedResponse;

public class ItemsClient {
    protected final ClientOptions clientOptions;
    private final RawItemsClient rawClient;

    public ItemsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawItemsClient(clientOptions);
    }

    public RawItemsClient withRawResponse() {
        return this.rawClient;
    }

    public PaginatedResponse list() {
        return this.rawClient.list().body();
    }

    public PaginatedResponse list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public NewsItem create(NewsItemRequest request) {
        return this.rawClient.create(request).body();
    }

    public NewsItem create(NewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public NewsItem find(FindNewsItemRequest request) {
        return this.rawClient.find(request).body();
    }

    public NewsItem find(FindNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public NewsItem update(UpdateNewsItemRequest request) {
        return this.rawClient.update(request).body();
    }

    public NewsItem update(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeletedObject delete(DeleteNewsItemRequest request) {
        return this.rawClient.delete(request).body();
    }

    public DeletedObject delete(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }
}

