/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.subscriptiontypes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Translation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionType {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<State> state;
    private final Optional<Translation> defaultTranslation;
    private final Optional<List<Translation>> translations;
    private final Optional<ConsentType> consentType;
    private final Optional<List<ContentTypesItem>> contentTypes;
    private final Map<String, Object> additionalProperties;

    private SubscriptionType(Optional<String> type, Optional<String> id, Optional<State> state, Optional<Translation> defaultTranslation, Optional<List<Translation>> translations, Optional<ConsentType> consentType, Optional<List<ContentTypesItem>> contentTypes, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.state = state;
        this.defaultTranslation = defaultTranslation;
        this.translations = translations;
        this.consentType = consentType;
        this.contentTypes = contentTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="default_translation")
    public Optional<Translation> getDefaultTranslation() {
        return this.defaultTranslation;
    }

    @JsonProperty(value="translations")
    public Optional<List<Translation>> getTranslations() {
        return this.translations;
    }

    @JsonProperty(value="consent_type")
    public Optional<ConsentType> getConsentType() {
        return this.consentType;
    }

    @JsonProperty(value="content_types")
    public Optional<List<ContentTypesItem>> getContentTypes() {
        return this.contentTypes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionType && this.equalTo((SubscriptionType)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionType other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.state.equals(other.state) && this.defaultTranslation.equals(other.defaultTranslation) && this.translations.equals(other.translations) && this.consentType.equals(other.consentType) && this.contentTypes.equals(other.contentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.state, this.defaultTranslation, this.translations, this.consentType, this.contentTypes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class ContentTypesItem {
        public static final ContentTypesItem EMAIL = new ContentTypesItem(Value.EMAIL, "email");
        public static final ContentTypesItem SMS_MESSAGE = new ContentTypesItem(Value.SMS_MESSAGE, "sms_message");
        private final Value value;
        private final String string;

        ContentTypesItem(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ContentTypesItem && this.string.equals(((ContentTypesItem)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case EMAIL: {
                    return visitor.visitEmail();
                }
                case SMS_MESSAGE: {
                    return visitor.visitSmsMessage();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static ContentTypesItem valueOf(String value) {
            switch (value) {
                case "email": {
                    return EMAIL;
                }
                case "sms_message": {
                    return SMS_MESSAGE;
                }
            }
            return new ContentTypesItem(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitEmail();

            public T visitSmsMessage();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            EMAIL,
            SMS_MESSAGE,
            UNKNOWN;

        }
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");
        public static final State ARCHIVED = new State(Value.ARCHIVED, "archived");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LIVE: {
                    return visitor.visitLive();
                }
                case ARCHIVED: {
                    return visitor.visitArchived();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live": {
                    return LIVE;
                }
                case "archived": {
                    return ARCHIVED;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitLive();

            public T visitDraft();

            public T visitArchived();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            LIVE,
            DRAFT,
            ARCHIVED,
            UNKNOWN;

        }
    }

    public static final class ConsentType {
        public static final ConsentType OPT_IN = new ConsentType(Value.OPT_IN, "opt_in");
        public static final ConsentType OPT_OUT = new ConsentType(Value.OPT_OUT, "opt_out");
        private final Value value;
        private final String string;

        ConsentType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ConsentType && this.string.equals(((ConsentType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case OPT_IN: {
                    return visitor.visitOptIn();
                }
                case OPT_OUT: {
                    return visitor.visitOptOut();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static ConsentType valueOf(String value) {
            switch (value) {
                case "opt_in": {
                    return OPT_IN;
                }
                case "opt_out": {
                    return OPT_OUT;
                }
            }
            return new ConsentType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitOptOut();

            public T visitOptIn();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            OPT_OUT,
            OPT_IN,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<Translation> defaultTranslation = Optional.empty();
        private Optional<List<Translation>> translations = Optional.empty();
        private Optional<ConsentType> consentType = Optional.empty();
        private Optional<List<ContentTypesItem>> contentTypes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SubscriptionType other) {
            this.type(other.getType());
            this.id(other.getId());
            this.state(other.getState());
            this.defaultTranslation(other.getDefaultTranslation());
            this.translations(other.getTranslations());
            this.consentType(other.getConsentType());
            this.contentTypes(other.getContentTypes());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="default_translation", nulls=Nulls.SKIP)
        public Builder defaultTranslation(Optional<Translation> defaultTranslation) {
            this.defaultTranslation = defaultTranslation;
            return this;
        }

        public Builder defaultTranslation(Translation defaultTranslation) {
            this.defaultTranslation = Optional.ofNullable(defaultTranslation);
            return this;
        }

        @JsonSetter(value="translations", nulls=Nulls.SKIP)
        public Builder translations(Optional<List<Translation>> translations) {
            this.translations = translations;
            return this;
        }

        public Builder translations(List<Translation> translations) {
            this.translations = Optional.ofNullable(translations);
            return this;
        }

        @JsonSetter(value="consent_type", nulls=Nulls.SKIP)
        public Builder consentType(Optional<ConsentType> consentType) {
            this.consentType = consentType;
            return this;
        }

        public Builder consentType(ConsentType consentType) {
            this.consentType = Optional.ofNullable(consentType);
            return this;
        }

        @JsonSetter(value="content_types", nulls=Nulls.SKIP)
        public Builder contentTypes(Optional<List<ContentTypesItem>> contentTypes) {
            this.contentTypes = contentTypes;
            return this;
        }

        public Builder contentTypes(List<ContentTypesItem> contentTypes) {
            this.contentTypes = Optional.ofNullable(contentTypes);
            return this;
        }

        public SubscriptionType build() {
            return new SubscriptionType(this.type, this.id, this.state, this.defaultTranslation, this.translations, this.consentType, this.contentTypes, this.additionalProperties);
        }
    }
}

