/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tags.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Tag {
    private final String id;
    private final String name;
    private final Optional<Integer> appliedAt;
    private final Optional<Reference> appliedBy;
    private final Map<String, Object> additionalProperties;

    private Tag(String id, String name, Optional<Integer> appliedAt, Optional<Reference> appliedBy, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.appliedAt = appliedAt;
        this.appliedBy = appliedBy;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "tag";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="applied_at")
    public Optional<Integer> getAppliedAt() {
        return this.appliedAt;
    }

    @JsonProperty(value="applied_by")
    public Optional<Reference> getAppliedBy() {
        return this.appliedBy;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Tag && this.equalTo((Tag)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tag other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.appliedAt.equals(other.appliedAt) && this.appliedBy.equals(other.appliedBy);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.appliedAt, this.appliedBy);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<Reference> appliedBy = Optional.empty();
        private Optional<Integer> appliedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Tag other) {
            this.id(other.getId());
            this.name(other.getName());
            this.appliedAt(other.getAppliedAt());
            this.appliedBy(other.getAppliedBy());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage appliedBy(Reference appliedBy) {
            this.appliedBy = Optional.ofNullable(appliedBy);
            return this;
        }

        @Override
        @JsonSetter(value="applied_by", nulls=Nulls.SKIP)
        public _FinalStage appliedBy(Optional<Reference> appliedBy) {
            this.appliedBy = appliedBy;
            return this;
        }

        @Override
        public _FinalStage appliedAt(Integer appliedAt) {
            this.appliedAt = Optional.ofNullable(appliedAt);
            return this;
        }

        @Override
        @JsonSetter(value="applied_at", nulls=Nulls.SKIP)
        public _FinalStage appliedAt(Optional<Integer> appliedAt) {
            this.appliedAt = appliedAt;
            return this;
        }

        @Override
        public Tag build() {
            return new Tag(this.id, this.name, this.appliedAt, this.appliedBy, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Tag build();

        public _FinalStage appliedAt(Optional<Integer> var1);

        public _FinalStage appliedAt(Integer var1);

        public _FinalStage appliedBy(Optional<Reference> var1);

        public _FinalStage appliedBy(Reference var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Tag var1);
    }
}

