/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.teams.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.AdminPriorityLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Team {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<List<Integer>> adminIds;
    private final Optional<AdminPriorityLevel> adminPriorityLevel;
    private final Optional<Integer> assignmentLimit;
    private final Optional<String> distributionMethod;
    private final Map<String, Object> additionalProperties;

    private Team(Optional<String> type, Optional<String> id, Optional<String> name, Optional<List<Integer>> adminIds, Optional<AdminPriorityLevel> adminPriorityLevel, Optional<Integer> assignmentLimit, Optional<String> distributionMethod, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.adminIds = adminIds;
        this.adminPriorityLevel = adminPriorityLevel;
        this.assignmentLimit = assignmentLimit;
        this.distributionMethod = distributionMethod;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="admin_ids")
    public Optional<List<Integer>> getAdminIds() {
        return this.adminIds;
    }

    @JsonProperty(value="admin_priority_level")
    public Optional<AdminPriorityLevel> getAdminPriorityLevel() {
        return this.adminPriorityLevel;
    }

    @JsonProperty(value="assignment_limit")
    public Optional<Integer> getAssignmentLimit() {
        return this.assignmentLimit;
    }

    @JsonProperty(value="distribution_method")
    public Optional<String> getDistributionMethod() {
        return this.distributionMethod;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Team && this.equalTo((Team)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Team other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.adminIds.equals(other.adminIds) && this.adminPriorityLevel.equals(other.adminPriorityLevel) && this.assignmentLimit.equals(other.assignmentLimit) && this.distributionMethod.equals(other.distributionMethod);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.adminIds, this.adminPriorityLevel, this.assignmentLimit, this.distributionMethod);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<List<Integer>> adminIds = Optional.empty();
        private Optional<AdminPriorityLevel> adminPriorityLevel = Optional.empty();
        private Optional<Integer> assignmentLimit = Optional.empty();
        private Optional<String> distributionMethod = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Team other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.adminIds(other.getAdminIds());
            this.adminPriorityLevel(other.getAdminPriorityLevel());
            this.assignmentLimit(other.getAssignmentLimit());
            this.distributionMethod(other.getDistributionMethod());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="admin_ids", nulls=Nulls.SKIP)
        public Builder adminIds(Optional<List<Integer>> adminIds) {
            this.adminIds = adminIds;
            return this;
        }

        public Builder adminIds(List<Integer> adminIds) {
            this.adminIds = Optional.ofNullable(adminIds);
            return this;
        }

        @JsonSetter(value="admin_priority_level", nulls=Nulls.SKIP)
        public Builder adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel) {
            this.adminPriorityLevel = adminPriorityLevel;
            return this;
        }

        public Builder adminPriorityLevel(AdminPriorityLevel adminPriorityLevel) {
            this.adminPriorityLevel = Optional.ofNullable(adminPriorityLevel);
            return this;
        }

        @JsonSetter(value="assignment_limit", nulls=Nulls.SKIP)
        public Builder assignmentLimit(Optional<Integer> assignmentLimit) {
            this.assignmentLimit = assignmentLimit;
            return this;
        }

        public Builder assignmentLimit(Integer assignmentLimit) {
            this.assignmentLimit = Optional.ofNullable(assignmentLimit);
            return this;
        }

        @JsonSetter(value="distribution_method", nulls=Nulls.SKIP)
        public Builder distributionMethod(Optional<String> distributionMethod) {
            this.distributionMethod = distributionMethod;
            return this;
        }

        public Builder distributionMethod(String distributionMethod) {
            this.distributionMethod = Optional.ofNullable(distributionMethod);
            return this;
        }

        public Team build() {
            return new Team(this.type, this.id, this.name, this.adminIds, this.adminPriorityLevel, this.assignmentLimit, this.distributionMethod, this.additionalProperties);
        }
    }
}

