/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateExternalPageRequest {
    private final String id;
    private final String title;
    private final String html;
    private final String url;
    private final Optional<Boolean> finAvailability;
    private final int sourceId;
    private final Optional<String> externalId;
    private final Map<String, Object> additionalProperties;

    private UpdateExternalPageRequest(String id, String title, String html, String url, Optional<Boolean> finAvailability, int sourceId, Optional<String> externalId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.html = html;
        this.url = url;
        this.finAvailability = finAvailability;
        this.sourceId = sourceId;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="html")
    public String getHtml() {
        return this.html;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="fin_availability")
    public Optional<Boolean> getFinAvailability() {
        return this.finAvailability;
    }

    @JsonProperty(value="locale")
    public String getLocale() {
        return "en";
    }

    @JsonProperty(value="source_id")
    public int getSourceId() {
        return this.sourceId;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateExternalPageRequest && this.equalTo((UpdateExternalPageRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateExternalPageRequest other) {
        return this.id.equals(other.id) && this.title.equals(other.title) && this.html.equals(other.html) && this.url.equals(other.url) && this.finAvailability.equals(other.finAvailability) && this.sourceId == other.sourceId && this.externalId.equals(other.externalId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.html, this.url, this.finAvailability, this.sourceId, this.externalId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TitleStage,
    HtmlStage,
    UrlStage,
    SourceIdStage,
    _FinalStage {
        private String id;
        private String title;
        private String html;
        private String url;
        private int sourceId;
        private Optional<String> externalId = Optional.empty();
        private Optional<Boolean> finAvailability = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateExternalPageRequest other) {
            this.id(other.getId());
            this.title(other.getTitle());
            this.html(other.getHtml());
            this.url(other.getUrl());
            this.finAvailability(other.getFinAvailability());
            this.sourceId(other.getSourceId());
            this.externalId(other.getExternalId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TitleStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public HtmlStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="html")
        public UrlStage html(@NotNull String html) {
            this.html = Objects.requireNonNull(html, "html must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public SourceIdStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source_id")
        public _FinalStage sourceId(int sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage finAvailability(Boolean finAvailability) {
            this.finAvailability = Optional.ofNullable(finAvailability);
            return this;
        }

        @Override
        @JsonSetter(value="fin_availability", nulls=Nulls.SKIP)
        public _FinalStage finAvailability(Optional<Boolean> finAvailability) {
            this.finAvailability = finAvailability;
            return this;
        }

        @Override
        public UpdateExternalPageRequest build() {
            return new UpdateExternalPageRequest(this.id, this.title, this.html, this.url, this.finAvailability, this.sourceId, this.externalId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateExternalPageRequest build();

        public _FinalStage finAvailability(Optional<Boolean> var1);

        public _FinalStage finAvailability(Boolean var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);
    }

    public static interface SourceIdStage {
        public _FinalStage sourceId(int var1);
    }

    public static interface UrlStage {
        public SourceIdStage url(@NotNull String var1);
    }

    public static interface HtmlStage {
        public UrlStage html(@NotNull String var1);
    }

    public static interface TitleStage {
        public HtmlStage title(@NotNull String var1);
    }

    public static interface IdStage {
        public TitleStage id(@NotNull String var1);

        public Builder from(UpdateExternalPageRequest var1);
    }
}

