/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.brands.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.brands.types.Brand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BrandList {
    private final Optional<String> type;
    private final Optional<List<Brand>> data;
    private final Map<String, Object> additionalProperties;

    private BrandList(Optional<String> type, Optional<List<Brand>> data, Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="data")
    public Optional<List<Brand>> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BrandList && this.equalTo((BrandList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BrandList other) {
        return this.type.equals(other.type) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Brand>> data = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BrandList other) {
            this.type(other.getType());
            this.data(other.getData());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<Brand>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Brand> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public BrandList build() {
            return new BrandList(this.type, this.data, this.additionalProperties);
        }
    }
}

