/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.calls;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.calls.AsyncRawCallsClient;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByExternalIdRequest;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByIdRequest;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByPhoneNumberRequest;
import com.intercom.api.resources.unstable.calls.requests.ListCallsRequest;
import com.intercom.api.resources.unstable.calls.requests.ListCallsWithTranscriptsRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallRecordingRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallTranscriptRequest;
import com.intercom.api.resources.unstable.calls.types.Call;
import com.intercom.api.resources.unstable.calls.types.ListCallsWithTranscriptsResponse;
import com.intercom.api.resources.unstable.types.AiCallResponse;
import com.intercom.api.resources.unstable.types.CallList;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.RegisterFinVoiceCallRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCallsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCallsClient rawClient;

    public AsyncCallsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCallsClient(clientOptions);
    }

    public AsyncRawCallsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CallList> listCalls() {
        return this.rawClient.listCalls().thenApply(response -> (CallList)response.body());
    }

    public CompletableFuture<CallList> listCalls(ListCallsRequest request) {
        return this.rawClient.listCalls(request).thenApply(response -> (CallList)response.body());
    }

    public CompletableFuture<CallList> listCalls(ListCallsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCalls(request, requestOptions).thenApply(response -> (CallList)response.body());
    }

    public CompletableFuture<Call> showCall(ShowCallRequest request) {
        return this.rawClient.showCall(request).thenApply(response -> (Call)response.body());
    }

    public CompletableFuture<Call> showCall(ShowCallRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCall(request, requestOptions).thenApply(response -> (Call)response.body());
    }

    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request) {
        return this.rawClient.showCallRecording(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallRecording(request, requestOptions).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<String> showCallTranscript(ShowCallTranscriptRequest request) {
        return this.rawClient.showCallTranscript(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> showCallTranscript(ShowCallTranscriptRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallTranscript(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(ListCallsWithTranscriptsRequest request) {
        return this.rawClient.listCallsWithTranscripts(request).thenApply(response -> (ListCallsWithTranscriptsResponse)response.body());
    }

    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(ListCallsWithTranscriptsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCallsWithTranscripts(request, requestOptions).thenApply(response -> (ListCallsWithTranscriptsResponse)response.body());
    }

    public CompletableFuture<AiCallResponse> registerFinVoiceCall() {
        return this.rawClient.registerFinVoiceCall().thenApply(response -> (AiCallResponse)response.body());
    }

    public CompletableFuture<AiCallResponse> registerFinVoiceCall(Optional<RegisterFinVoiceCallRequest> request) {
        return this.rawClient.registerFinVoiceCall(request).thenApply(response -> (AiCallResponse)response.body());
    }

    public CompletableFuture<AiCallResponse> registerFinVoiceCall(Optional<RegisterFinVoiceCallRequest> request, RequestOptions requestOptions) {
        return this.rawClient.registerFinVoiceCall(request, requestOptions).thenApply(response -> (AiCallResponse)response.body());
    }

    public CompletableFuture<AiCallResponse> collectFinVoiceCallById(CollectFinVoiceCallByIdRequest request) {
        return this.rawClient.collectFinVoiceCallById(request).thenApply(response -> (AiCallResponse)response.body());
    }

    public CompletableFuture<AiCallResponse> collectFinVoiceCallById(CollectFinVoiceCallByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.collectFinVoiceCallById(request, requestOptions).thenApply(response -> (AiCallResponse)response.body());
    }

    public CompletableFuture<AiCallResponse> collectFinVoiceCallByExternalId(CollectFinVoiceCallByExternalIdRequest request) {
        return this.rawClient.collectFinVoiceCallByExternalId(request).thenApply(response -> (AiCallResponse)response.body());
    }

    public CompletableFuture<AiCallResponse> collectFinVoiceCallByExternalId(CollectFinVoiceCallByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.collectFinVoiceCallByExternalId(request, requestOptions).thenApply(response -> (AiCallResponse)response.body());
    }

    public CompletableFuture<Error> collectFinVoiceCallByPhoneNumber(CollectFinVoiceCallByPhoneNumberRequest request) {
        return this.rawClient.collectFinVoiceCallByPhoneNumber(request).thenApply(response -> (Error)response.body());
    }

    public CompletableFuture<Error> collectFinVoiceCallByPhoneNumber(CollectFinVoiceCallByPhoneNumberRequest request, RequestOptions requestOptions) {
        return this.rawClient.collectFinVoiceCallByPhoneNumber(request, requestOptions).thenApply(response -> (Error)response.body());
    }
}

