/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.calls.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.calls.types.ICall;
import com.intercom.api.resources.unstable.types.Datetime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Call
implements ICall {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> conversationId;
    private final Optional<String> adminId;
    private final Optional<String> contactId;
    private final Optional<String> state;
    private final Optional<Datetime> initiatedAt;
    private final Optional<Datetime> answeredAt;
    private final Optional<Datetime> endedAt;
    private final Optional<Datetime> createdAt;
    private final Optional<Datetime> updatedAt;
    private final Optional<String> recordingUrl;
    private final Optional<String> transcriptionUrl;
    private final Optional<String> callType;
    private final Optional<String> direction;
    private final Optional<String> endedReason;
    private final Optional<String> phone;
    private final Optional<String> finRecordingUrl;
    private final Optional<String> finTranscriptionUrl;
    private final Map<String, Object> additionalProperties;

    private Call(Optional<String> type, Optional<String> id, Optional<String> conversationId, Optional<String> adminId, Optional<String> contactId, Optional<String> state, Optional<Datetime> initiatedAt, Optional<Datetime> answeredAt, Optional<Datetime> endedAt, Optional<Datetime> createdAt, Optional<Datetime> updatedAt, Optional<String> recordingUrl, Optional<String> transcriptionUrl, Optional<String> callType, Optional<String> direction, Optional<String> endedReason, Optional<String> phone, Optional<String> finRecordingUrl, Optional<String> finTranscriptionUrl, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.conversationId = conversationId;
        this.adminId = adminId;
        this.contactId = contactId;
        this.state = state;
        this.initiatedAt = initiatedAt;
        this.answeredAt = answeredAt;
        this.endedAt = endedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.recordingUrl = recordingUrl;
        this.transcriptionUrl = transcriptionUrl;
        this.callType = callType;
        this.direction = direction;
        this.endedReason = endedReason;
        this.phone = phone;
        this.finRecordingUrl = finRecordingUrl;
        this.finTranscriptionUrl = finTranscriptionUrl;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="conversation_id")
    public Optional<String> getConversationId() {
        return this.conversationId;
    }

    @Override
    @JsonProperty(value="admin_id")
    public Optional<String> getAdminId() {
        return this.adminId;
    }

    @Override
    @JsonProperty(value="contact_id")
    public Optional<String> getContactId() {
        return this.contactId;
    }

    @Override
    @JsonProperty(value="state")
    public Optional<String> getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="initiated_at")
    public Optional<Datetime> getInitiatedAt() {
        return this.initiatedAt;
    }

    @Override
    @JsonProperty(value="answered_at")
    public Optional<Datetime> getAnsweredAt() {
        return this.answeredAt;
    }

    @Override
    @JsonProperty(value="ended_at")
    public Optional<Datetime> getEndedAt() {
        return this.endedAt;
    }

    @Override
    @JsonProperty(value="created_at")
    public Optional<Datetime> getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updated_at")
    public Optional<Datetime> getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="recording_url")
    public Optional<String> getRecordingUrl() {
        return this.recordingUrl;
    }

    @Override
    @JsonProperty(value="transcription_url")
    public Optional<String> getTranscriptionUrl() {
        return this.transcriptionUrl;
    }

    @Override
    @JsonProperty(value="call_type")
    public Optional<String> getCallType() {
        return this.callType;
    }

    @Override
    @JsonProperty(value="direction")
    public Optional<String> getDirection() {
        return this.direction;
    }

    @Override
    @JsonProperty(value="ended_reason")
    public Optional<String> getEndedReason() {
        return this.endedReason;
    }

    @Override
    @JsonProperty(value="phone")
    public Optional<String> getPhone() {
        return this.phone;
    }

    @Override
    @JsonProperty(value="fin_recording_url")
    public Optional<String> getFinRecordingUrl() {
        return this.finRecordingUrl;
    }

    @Override
    @JsonProperty(value="fin_transcription_url")
    public Optional<String> getFinTranscriptionUrl() {
        return this.finTranscriptionUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Call && this.equalTo((Call)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Call other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.conversationId.equals(other.conversationId) && this.adminId.equals(other.adminId) && this.contactId.equals(other.contactId) && this.state.equals(other.state) && this.initiatedAt.equals(other.initiatedAt) && this.answeredAt.equals(other.answeredAt) && this.endedAt.equals(other.endedAt) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.recordingUrl.equals(other.recordingUrl) && this.transcriptionUrl.equals(other.transcriptionUrl) && this.callType.equals(other.callType) && this.direction.equals(other.direction) && this.endedReason.equals(other.endedReason) && this.phone.equals(other.phone) && this.finRecordingUrl.equals(other.finRecordingUrl) && this.finTranscriptionUrl.equals(other.finTranscriptionUrl);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.conversationId, this.adminId, this.contactId, this.state, this.initiatedAt, this.answeredAt, this.endedAt, this.createdAt, this.updatedAt, this.recordingUrl, this.transcriptionUrl, this.callType, this.direction, this.endedReason, this.phone, this.finRecordingUrl, this.finTranscriptionUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> conversationId = Optional.empty();
        private Optional<String> adminId = Optional.empty();
        private Optional<String> contactId = Optional.empty();
        private Optional<String> state = Optional.empty();
        private Optional<Datetime> initiatedAt = Optional.empty();
        private Optional<Datetime> answeredAt = Optional.empty();
        private Optional<Datetime> endedAt = Optional.empty();
        private Optional<Datetime> createdAt = Optional.empty();
        private Optional<Datetime> updatedAt = Optional.empty();
        private Optional<String> recordingUrl = Optional.empty();
        private Optional<String> transcriptionUrl = Optional.empty();
        private Optional<String> callType = Optional.empty();
        private Optional<String> direction = Optional.empty();
        private Optional<String> endedReason = Optional.empty();
        private Optional<String> phone = Optional.empty();
        private Optional<String> finRecordingUrl = Optional.empty();
        private Optional<String> finTranscriptionUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Call other) {
            this.type(other.getType());
            this.id(other.getId());
            this.conversationId(other.getConversationId());
            this.adminId(other.getAdminId());
            this.contactId(other.getContactId());
            this.state(other.getState());
            this.initiatedAt(other.getInitiatedAt());
            this.answeredAt(other.getAnsweredAt());
            this.endedAt(other.getEndedAt());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.recordingUrl(other.getRecordingUrl());
            this.transcriptionUrl(other.getTranscriptionUrl());
            this.callType(other.getCallType());
            this.direction(other.getDirection());
            this.endedReason(other.getEndedReason());
            this.phone(other.getPhone());
            this.finRecordingUrl(other.getFinRecordingUrl());
            this.finTranscriptionUrl(other.getFinTranscriptionUrl());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="conversation_id", nulls=Nulls.SKIP)
        public Builder conversationId(Optional<String> conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = Optional.ofNullable(conversationId);
            return this;
        }

        @JsonSetter(value="admin_id", nulls=Nulls.SKIP)
        public Builder adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        @JsonSetter(value="contact_id", nulls=Nulls.SKIP)
        public Builder contactId(Optional<String> contactId) {
            this.contactId = contactId;
            return this;
        }

        public Builder contactId(String contactId) {
            this.contactId = Optional.ofNullable(contactId);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<String> state) {
            this.state = state;
            return this;
        }

        public Builder state(String state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="initiated_at", nulls=Nulls.SKIP)
        public Builder initiatedAt(Optional<Datetime> initiatedAt) {
            this.initiatedAt = initiatedAt;
            return this;
        }

        public Builder initiatedAt(Datetime initiatedAt) {
            this.initiatedAt = Optional.ofNullable(initiatedAt);
            return this;
        }

        @JsonSetter(value="answered_at", nulls=Nulls.SKIP)
        public Builder answeredAt(Optional<Datetime> answeredAt) {
            this.answeredAt = answeredAt;
            return this;
        }

        public Builder answeredAt(Datetime answeredAt) {
            this.answeredAt = Optional.ofNullable(answeredAt);
            return this;
        }

        @JsonSetter(value="ended_at", nulls=Nulls.SKIP)
        public Builder endedAt(Optional<Datetime> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public Builder endedAt(Datetime endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Datetime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Datetime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Datetime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Datetime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="recording_url", nulls=Nulls.SKIP)
        public Builder recordingUrl(Optional<String> recordingUrl) {
            this.recordingUrl = recordingUrl;
            return this;
        }

        public Builder recordingUrl(String recordingUrl) {
            this.recordingUrl = Optional.ofNullable(recordingUrl);
            return this;
        }

        @JsonSetter(value="transcription_url", nulls=Nulls.SKIP)
        public Builder transcriptionUrl(Optional<String> transcriptionUrl) {
            this.transcriptionUrl = transcriptionUrl;
            return this;
        }

        public Builder transcriptionUrl(String transcriptionUrl) {
            this.transcriptionUrl = Optional.ofNullable(transcriptionUrl);
            return this;
        }

        @JsonSetter(value="call_type", nulls=Nulls.SKIP)
        public Builder callType(Optional<String> callType) {
            this.callType = callType;
            return this;
        }

        public Builder callType(String callType) {
            this.callType = Optional.ofNullable(callType);
            return this;
        }

        @JsonSetter(value="direction", nulls=Nulls.SKIP)
        public Builder direction(Optional<String> direction) {
            this.direction = direction;
            return this;
        }

        public Builder direction(String direction) {
            this.direction = Optional.ofNullable(direction);
            return this;
        }

        @JsonSetter(value="ended_reason", nulls=Nulls.SKIP)
        public Builder endedReason(Optional<String> endedReason) {
            this.endedReason = endedReason;
            return this;
        }

        public Builder endedReason(String endedReason) {
            this.endedReason = Optional.ofNullable(endedReason);
            return this;
        }

        @JsonSetter(value="phone", nulls=Nulls.SKIP)
        public Builder phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        @JsonSetter(value="fin_recording_url", nulls=Nulls.SKIP)
        public Builder finRecordingUrl(Optional<String> finRecordingUrl) {
            this.finRecordingUrl = finRecordingUrl;
            return this;
        }

        public Builder finRecordingUrl(String finRecordingUrl) {
            this.finRecordingUrl = Optional.ofNullable(finRecordingUrl);
            return this;
        }

        @JsonSetter(value="fin_transcription_url", nulls=Nulls.SKIP)
        public Builder finTranscriptionUrl(Optional<String> finTranscriptionUrl) {
            this.finTranscriptionUrl = finTranscriptionUrl;
            return this;
        }

        public Builder finTranscriptionUrl(String finTranscriptionUrl) {
            this.finTranscriptionUrl = Optional.ofNullable(finTranscriptionUrl);
            return this;
        }

        public Call build() {
            return new Call(this.type, this.id, this.conversationId, this.adminId, this.contactId, this.state, this.initiatedAt, this.answeredAt, this.endedAt, this.createdAt, this.updatedAt, this.recordingUrl, this.transcriptionUrl, this.callType, this.direction, this.endedReason, this.phone, this.finRecordingUrl, this.finTranscriptionUrl, this.additionalProperties);
        }
    }
}

