/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RetrieveCompanyRequest {
    private final Optional<String> name;
    private final Optional<String> companyId;
    private final Optional<String> tagId;
    private final Optional<String> segmentId;
    private final Optional<Integer> page;
    private final Optional<Integer> perPage;
    private final Map<String, Object> additionalProperties;

    private RetrieveCompanyRequest(Optional<String> name, Optional<String> companyId, Optional<String> tagId, Optional<String> segmentId, Optional<Integer> page, Optional<Integer> perPage, Map<String, Object> additionalProperties) {
        this.name = name;
        this.companyId = companyId;
        this.tagId = tagId;
        this.segmentId = segmentId;
        this.page = page;
        this.perPage = perPage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="tag_id")
    public Optional<String> getTagId() {
        return this.tagId;
    }

    @JsonProperty(value="segment_id")
    public Optional<String> getSegmentId() {
        return this.segmentId;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="per_page")
    public Optional<Integer> getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RetrieveCompanyRequest && this.equalTo((RetrieveCompanyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RetrieveCompanyRequest other) {
        return this.name.equals(other.name) && this.companyId.equals(other.companyId) && this.tagId.equals(other.tagId) && this.segmentId.equals(other.segmentId) && this.page.equals(other.page) && this.perPage.equals(other.perPage);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.companyId, this.tagId, this.segmentId, this.page, this.perPage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<String> tagId = Optional.empty();
        private Optional<String> segmentId = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> perPage = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RetrieveCompanyRequest other) {
            this.name(other.getName());
            this.companyId(other.getCompanyId());
            this.tagId(other.getTagId());
            this.segmentId(other.getSegmentId());
            this.page(other.getPage());
            this.perPage(other.getPerPage());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="tag_id", nulls=Nulls.SKIP)
        public Builder tagId(Optional<String> tagId) {
            this.tagId = tagId;
            return this;
        }

        public Builder tagId(String tagId) {
            this.tagId = Optional.ofNullable(tagId);
            return this;
        }

        @JsonSetter(value="segment_id", nulls=Nulls.SKIP)
        public Builder segmentId(Optional<String> segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public Builder segmentId(String segmentId) {
            this.segmentId = Optional.ofNullable(segmentId);
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="per_page", nulls=Nulls.SKIP)
        public Builder perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        public RetrieveCompanyRequest build() {
            return new RetrieveCompanyRequest(this.name, this.companyId, this.tagId, this.segmentId, this.page, this.perPage, this.additionalProperties);
        }
    }
}

