/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.contacts;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.contacts.AsyncRawContactsClient;
import com.intercom.api.resources.unstable.contacts.requests.ArchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.BlockContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.DeleteContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListCompaniesForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSegmentsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSubscriptionsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListTagsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.MergeContactsRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactByExternalIdRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UnarchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UpdateContactRequest;
import com.intercom.api.resources.unstable.contacts.types.CreateContactResponse;
import com.intercom.api.resources.unstable.contacts.types.MergeContactResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactByExternalIdResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactResponse;
import com.intercom.api.resources.unstable.contacts.types.UpdateContactResponse;
import com.intercom.api.resources.unstable.types.ContactArchived;
import com.intercom.api.resources.unstable.types.ContactAttachedCompanies;
import com.intercom.api.resources.unstable.types.ContactBlocked;
import com.intercom.api.resources.unstable.types.ContactDeleted;
import com.intercom.api.resources.unstable.types.ContactList;
import com.intercom.api.resources.unstable.types.ContactSegments;
import com.intercom.api.resources.unstable.types.ContactUnarchived;
import com.intercom.api.resources.unstable.types.SearchRequest;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;
import com.intercom.api.resources.unstable.types.TagList;
import java.util.concurrent.CompletableFuture;

public class AsyncContactsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawContactsClient rawClient;

    public AsyncContactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawContactsClient(clientOptions);
    }

    public AsyncRawContactsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ContactAttachedCompanies> listCompaniesForAContact(ListCompaniesForAContactRequest request) {
        return this.rawClient.listCompaniesForAContact(request).thenApply(response -> (ContactAttachedCompanies)response.body());
    }

    public CompletableFuture<ContactAttachedCompanies> listCompaniesForAContact(ListCompaniesForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompaniesForAContact(request, requestOptions).thenApply(response -> (ContactAttachedCompanies)response.body());
    }

    public CompletableFuture<ContactSegments> listSegmentsForAContact(ListSegmentsForAContactRequest request) {
        return this.rawClient.listSegmentsForAContact(request).thenApply(response -> (ContactSegments)response.body());
    }

    public CompletableFuture<ContactSegments> listSegmentsForAContact(ListSegmentsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listSegmentsForAContact(request, requestOptions).thenApply(response -> (ContactSegments)response.body());
    }

    public CompletableFuture<SubscriptionTypeList> listSubscriptionsForAContact(ListSubscriptionsForAContactRequest request) {
        return this.rawClient.listSubscriptionsForAContact(request).thenApply(response -> (SubscriptionTypeList)response.body());
    }

    public CompletableFuture<SubscriptionTypeList> listSubscriptionsForAContact(ListSubscriptionsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listSubscriptionsForAContact(request, requestOptions).thenApply(response -> (SubscriptionTypeList)response.body());
    }

    public CompletableFuture<TagList> listTagsForAContact(ListTagsForAContactRequest request) {
        return this.rawClient.listTagsForAContact(request).thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<TagList> listTagsForAContact(ListTagsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listTagsForAContact(request, requestOptions).thenApply(response -> (TagList)response.body());
    }

    public CompletableFuture<ShowContactResponse> showContact(ShowContactRequest request) {
        return this.rawClient.showContact(request).thenApply(response -> (ShowContactResponse)response.body());
    }

    public CompletableFuture<ShowContactResponse> showContact(ShowContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.showContact(request, requestOptions).thenApply(response -> (ShowContactResponse)response.body());
    }

    public CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest request) {
        return this.rawClient.updateContact(request).thenApply(response -> (UpdateContactResponse)response.body());
    }

    public CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateContact(request, requestOptions).thenApply(response -> (UpdateContactResponse)response.body());
    }

    public CompletableFuture<ContactDeleted> deleteContact(DeleteContactRequest request) {
        return this.rawClient.deleteContact(request).thenApply(response -> (ContactDeleted)response.body());
    }

    public CompletableFuture<ContactDeleted> deleteContact(DeleteContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteContact(request, requestOptions).thenApply(response -> (ContactDeleted)response.body());
    }

    public CompletableFuture<MergeContactResponse> mergeContact() {
        return this.rawClient.mergeContact().thenApply(response -> (MergeContactResponse)response.body());
    }

    public CompletableFuture<MergeContactResponse> mergeContact(MergeContactsRequest request) {
        return this.rawClient.mergeContact(request).thenApply(response -> (MergeContactResponse)response.body());
    }

    public CompletableFuture<MergeContactResponse> mergeContact(MergeContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeContact(request, requestOptions).thenApply(response -> (MergeContactResponse)response.body());
    }

    public CompletableFuture<ContactList> searchContacts(SearchRequest request) {
        return this.rawClient.searchContacts(request).thenApply(response -> (ContactList)response.body());
    }

    public CompletableFuture<ContactList> searchContacts(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchContacts(request, requestOptions).thenApply(response -> (ContactList)response.body());
    }

    public CompletableFuture<ContactList> listContacts() {
        return this.rawClient.listContacts().thenApply(response -> (ContactList)response.body());
    }

    public CompletableFuture<ContactList> listContacts(RequestOptions requestOptions) {
        return this.rawClient.listContacts(requestOptions).thenApply(response -> (ContactList)response.body());
    }

    public CompletableFuture<CreateContactResponse> createContact(Object request) {
        return this.rawClient.createContact(request).thenApply(response -> (CreateContactResponse)response.body());
    }

    public CompletableFuture<CreateContactResponse> createContact(Object request, RequestOptions requestOptions) {
        return this.rawClient.createContact(request, requestOptions).thenApply(response -> (CreateContactResponse)response.body());
    }

    public CompletableFuture<ShowContactByExternalIdResponse> showContactByExternalId(ShowContactByExternalIdRequest request) {
        return this.rawClient.showContactByExternalId(request).thenApply(response -> (ShowContactByExternalIdResponse)response.body());
    }

    public CompletableFuture<ShowContactByExternalIdResponse> showContactByExternalId(ShowContactByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.showContactByExternalId(request, requestOptions).thenApply(response -> (ShowContactByExternalIdResponse)response.body());
    }

    public CompletableFuture<ContactArchived> archiveContact(ArchiveContactRequest request) {
        return this.rawClient.archiveContact(request).thenApply(response -> (ContactArchived)response.body());
    }

    public CompletableFuture<ContactArchived> archiveContact(ArchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.archiveContact(request, requestOptions).thenApply(response -> (ContactArchived)response.body());
    }

    public CompletableFuture<ContactUnarchived> unarchiveContact(UnarchiveContactRequest request) {
        return this.rawClient.unarchiveContact(request).thenApply(response -> (ContactUnarchived)response.body());
    }

    public CompletableFuture<ContactUnarchived> unarchiveContact(UnarchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.unarchiveContact(request, requestOptions).thenApply(response -> (ContactUnarchived)response.body());
    }

    public CompletableFuture<ContactBlocked> blockContact(BlockContactRequest request) {
        return this.rawClient.blockContact(request).thenApply(response -> (ContactBlocked)response.body());
    }

    public CompletableFuture<ContactBlocked> blockContact(BlockContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.blockContact(request, requestOptions).thenApply(response -> (ContactBlocked)response.body());
    }
}

