/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateConversationRequest {
    private final From from;
    private final String body;
    private final Optional<Integer> createdAt;
    private final Map<String, Object> additionalProperties;

    private CreateConversationRequest(From from, String body, Optional<Integer> createdAt, Map<String, Object> additionalProperties) {
        this.from = from;
        this.body = body;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="from")
    public From getFrom() {
        return this.from;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateConversationRequest && this.equalTo((CreateConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateConversationRequest other) {
        return this.from.equals(other.from) && this.body.equals(other.body) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.body, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FromStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class From {
        private final Type type;
        private final String id;
        private final Map<String, Object> additionalProperties;

        private From(Type type, String id, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Type getType() {
            return this.type;
        }

        @JsonProperty(value="id")
        public String getId() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof From && this.equalTo((From)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(From other) {
            return this.type.equals(other.type) && this.id.equals(other.id);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static TypeStage builder() {
            return new Builder();
        }

        public static final class Type {
            public static final Type USER = new Type(Value.USER, "user");
            public static final Type CONTACT = new Type(Value.CONTACT, "contact");
            public static final Type LEAD = new Type(Value.LEAD, "lead");
            private final Value value;
            private final String string;

            Type(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return this.value;
            }

            @JsonValue
            public String toString() {
                return this.string;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof Type && this.string.equals(((Type)other).string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (this.value) {
                    case USER: {
                        return visitor.visitUser();
                    }
                    case CONTACT: {
                        return visitor.visitContact();
                    }
                    case LEAD: {
                        return visitor.visitLead();
                    }
                }
                return visitor.visitUnknown(this.string);
            }

            @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
            public static Type valueOf(String value) {
                switch (value) {
                    case "user": {
                        return USER;
                    }
                    case "contact": {
                        return CONTACT;
                    }
                    case "lead": {
                        return LEAD;
                    }
                }
                return new Type(Value.UNKNOWN, value);
            }

            public static interface Visitor<T> {
                public T visitLead();

                public T visitUser();

                public T visitContact();

                public T visitUnknown(String var1);
            }

            public static enum Value {
                LEAD,
                USER,
                CONTACT,
                UNKNOWN;

            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements TypeStage,
        IdStage,
        _FinalStage {
            private Type type;
            private String id;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(From other) {
                this.type(other.getType());
                this.id(other.getId());
                return this;
            }

            @Override
            @JsonSetter(value="type")
            public IdStage type(@NotNull Type type) {
                this.type = Objects.requireNonNull(type, "type must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="id")
            public _FinalStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            @Override
            public From build() {
                return new From(this.type, this.id, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public From build();
        }

        public static interface IdStage {
            public _FinalStage id(@NotNull String var1);
        }

        public static interface TypeStage {
            public IdStage type(@NotNull Type var1);

            public Builder from(From var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FromStage,
    BodyStage,
    _FinalStage {
        private From from;
        private String body;
        private Optional<Integer> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateConversationRequest other) {
            this.from(other.getFrom());
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="from")
        public BodyStage from(@NotNull From from) {
            this.from = Objects.requireNonNull(from, "from must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateConversationRequest build() {
            return new CreateConversationRequest(this.from, this.body, this.createdAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateConversationRequest build();

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull String var1);
    }

    public static interface FromStage {
        public BodyStage from(@NotNull From var1);

        public Builder from(CreateConversationRequest var1);
    }
}

