/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataexport;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataexport.AsyncRawDataExportClient;
import com.intercom.api.resources.unstable.dataexport.requests.CancelDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.requests.CreateDataExportsRequest;
import com.intercom.api.resources.unstable.dataexport.requests.DownloadDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.requests.GetDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.types.DataExport;
import java.util.concurrent.CompletableFuture;

public class AsyncDataExportClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDataExportClient rawClient;

    public AsyncDataExportClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDataExportClient(clientOptions);
    }

    public AsyncRawDataExportClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DataExport> createDataExport(CreateDataExportsRequest request) {
        return this.rawClient.createDataExport(request).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> createDataExport(CreateDataExportsRequest request, RequestOptions requestOptions) {
        return this.rawClient.createDataExport(request, requestOptions).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> getDataExport(GetDataExportRequest request) {
        return this.rawClient.getDataExport(request).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> getDataExport(GetDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.getDataExport(request, requestOptions).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> cancelDataExport(CancelDataExportRequest request) {
        return this.rawClient.cancelDataExport(request).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> cancelDataExport(CancelDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancelDataExport(request, requestOptions).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<Void> downloadDataExport(DownloadDataExportRequest request) {
        return this.rawClient.downloadDataExport(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> downloadDataExport(DownloadDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.downloadDataExport(request, requestOptions).thenApply(response -> (Void)response.body());
    }
}

