/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataexport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataexport.requests.CancelDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.requests.CreateDataExportsRequest;
import com.intercom.api.resources.unstable.dataexport.requests.DownloadDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.requests.GetDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.types.DataExport;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawDataExportClient {
    protected final ClientOptions clientOptions;

    public AsyncRawDataExportClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<IntercomHttpResponse<DataExport>> createDataExport(CreateDataExportsRequest request) {
        return this.createDataExport(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<DataExport>> createDataExport(CreateDataExportsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("export/content/data").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<DataExport>> future = new CompletableFuture<IntercomHttpResponse<DataExport>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    String responseBodyString;
                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<DataExport>((DataExport)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataExport.class), response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<IntercomHttpResponse<DataExport>> getDataExport(GetDataExportRequest request) {
        return this.getDataExport(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<DataExport>> getDataExport(GetDataExportRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("export/content/data").addPathSegment(request.getJobIdentifier()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<DataExport>> future = new CompletableFuture<IntercomHttpResponse<DataExport>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    String responseBodyString;
                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<DataExport>((DataExport)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataExport.class), response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<IntercomHttpResponse<DataExport>> cancelDataExport(CancelDataExportRequest request) {
        return this.cancelDataExport(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<DataExport>> cancelDataExport(CancelDataExportRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("export/cancel").addPathSegment(request.getJobIdentifier()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<DataExport>> future = new CompletableFuture<IntercomHttpResponse<DataExport>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    String responseBodyString;
                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<DataExport>((DataExport)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataExport.class), response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<IntercomHttpResponse<Void>> downloadDataExport(DownloadDataExportRequest request) {
        return this.downloadDataExport(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<Void>> downloadDataExport(DownloadDataExportRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("download/content/data").addPathSegment(request.getJobIdentifier()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions)));
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<Void>> future = new CompletableFuture<IntercomHttpResponse<Void>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<Object>(null, response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

