/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.macros;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.macros.AsyncRawMacrosClient;
import com.intercom.api.resources.unstable.macros.requests.GetMacroRequest;
import com.intercom.api.resources.unstable.macros.requests.ListMacrosRequest;
import com.intercom.api.resources.unstable.macros.types.Macro;
import com.intercom.api.resources.unstable.macros.types.MacroList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncMacrosClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawMacrosClient rawClient;

    public AsyncMacrosClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawMacrosClient(clientOptions);
    }

    public AsyncRawMacrosClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<MacroList> listMacros() {
        return this.rawClient.listMacros().thenApply(response -> (MacroList)response.body());
    }

    public CompletableFuture<MacroList> listMacros(ListMacrosRequest request) {
        return this.rawClient.listMacros(request).thenApply(response -> (MacroList)response.body());
    }

    public CompletableFuture<MacroList> listMacros(ListMacrosRequest request, RequestOptions requestOptions) {
        return this.rawClient.listMacros(request, requestOptions).thenApply(response -> (MacroList)response.body());
    }

    public CompletableFuture<Optional<Macro>> getMacro(GetMacroRequest request) {
        return this.rawClient.getMacro(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Macro>> getMacro(GetMacroRequest request, RequestOptions requestOptions) {
        return this.rawClient.getMacro(request, requestOptions).thenApply(response -> (Optional)response.body());
    }
}

