/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.macros.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.macros.types.Macro;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MacroList {
    private final Optional<String> type;
    private final Optional<List<Optional<Macro>>> data;
    private final Optional<Pages> pages;
    private final Map<String, Object> additionalProperties;

    private MacroList(Optional<String> type, Optional<List<Optional<Macro>>> data, Optional<Pages> pages, Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="data")
    public Optional<List<Optional<Macro>>> getData() {
        return this.data;
    }

    @JsonProperty(value="pages")
    public Optional<Pages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MacroList && this.equalTo((MacroList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MacroList other) {
        return this.type.equals(other.type) && this.data.equals(other.data) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Pages {
        private final Optional<String> type;
        private final Optional<Integer> perPage;
        private final Optional<Next> next;
        private final Map<String, Object> additionalProperties;

        private Pages(Optional<String> type, Optional<Integer> perPage, Optional<Next> next, Map<String, Object> additionalProperties) {
            this.type = type;
            this.perPage = perPage;
            this.next = next;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="per_page")
        public Optional<Integer> getPerPage() {
            return this.perPage;
        }

        @JsonProperty(value="next")
        public Optional<Next> getNext() {
            return this.next;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Pages && this.equalTo((Pages)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Pages other) {
            return this.type.equals(other.type) && this.perPage.equals(other.perPage) && this.next.equals(other.next);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.perPage, this.next);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class Next {
            private final Optional<String> startingAfter;
            private final Map<String, Object> additionalProperties;

            private Next(Optional<String> startingAfter, Map<String, Object> additionalProperties) {
                this.startingAfter = startingAfter;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="starting_after")
            public Optional<String> getStartingAfter() {
                return this.startingAfter;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof Next && this.equalTo((Next)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Next other) {
                return this.startingAfter.equals(other.startingAfter);
            }

            public int hashCode() {
                return Objects.hash(this.startingAfter);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder {
                private Optional<String> startingAfter = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                public Builder from(Next other) {
                    this.startingAfter(other.getStartingAfter());
                    return this;
                }

                @JsonSetter(value="starting_after", nulls=Nulls.SKIP)
                public Builder startingAfter(Optional<String> startingAfter) {
                    this.startingAfter = startingAfter;
                    return this;
                }

                public Builder startingAfter(String startingAfter) {
                    this.startingAfter = Optional.ofNullable(startingAfter);
                    return this;
                }

                public Next build() {
                    return new Next(this.startingAfter, this.additionalProperties);
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<Integer> perPage = Optional.empty();
            private Optional<Next> next = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Pages other) {
                this.type(other.getType());
                this.perPage(other.getPerPage());
                this.next(other.getNext());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="per_page", nulls=Nulls.SKIP)
            public Builder perPage(Optional<Integer> perPage) {
                this.perPage = perPage;
                return this;
            }

            public Builder perPage(Integer perPage) {
                this.perPage = Optional.ofNullable(perPage);
                return this;
            }

            @JsonSetter(value="next", nulls=Nulls.SKIP)
            public Builder next(Optional<Next> next) {
                this.next = next;
                return this;
            }

            public Builder next(Next next) {
                this.next = Optional.ofNullable(next);
                return this;
            }

            public Pages build() {
                return new Pages(this.type, this.perPage, this.next, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Optional<Macro>>> data = Optional.empty();
        private Optional<Pages> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MacroList other) {
            this.type(other.getType());
            this.data(other.getData());
            this.pages(other.getPages());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<Optional<Macro>>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Optional<Macro>> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<Pages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(Pages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public MacroList build() {
            return new MacroList(this.type, this.data, this.pages, this.additionalProperties);
        }
    }
}

