/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.messages.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Message {
    private final String type;
    private final String id;
    private final int createdAt;
    private final Optional<String> subject;
    private final String body;
    private final MessageType messageType;
    private final Optional<String> conversationId;
    private final Map<String, Object> additionalProperties;

    private Message(String type, String id, int createdAt, Optional<String> subject, String body, MessageType messageType, Optional<String> conversationId, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.createdAt = createdAt;
        this.subject = subject;
        this.body = body;
        this.messageType = messageType;
        this.conversationId = conversationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="subject")
    public Optional<String> getSubject() {
        return this.subject;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="message_type")
    public MessageType getMessageType() {
        return this.messageType;
    }

    @JsonProperty(value="conversation_id")
    public Optional<String> getConversationId() {
        return this.conversationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Message && this.equalTo((Message)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Message other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.createdAt == other.createdAt && this.subject.equals(other.subject) && this.body.equals(other.body) && this.messageType.equals(other.messageType) && this.conversationId.equals(other.conversationId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.createdAt, this.subject, this.body, this.messageType, this.conversationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class MessageType {
        public static final MessageType EMAIL = new MessageType(Value.EMAIL, "email");
        public static final MessageType FACEBOOK = new MessageType(Value.FACEBOOK, "facebook");
        public static final MessageType INAPP = new MessageType(Value.INAPP, "inapp");
        public static final MessageType WHATSAPP = new MessageType(Value.WHATSAPP, "whatsapp");
        public static final MessageType SMS = new MessageType(Value.SMS, "sms");
        public static final MessageType TWITTER = new MessageType(Value.TWITTER, "twitter");
        private final Value value;
        private final String string;

        MessageType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof MessageType && this.string.equals(((MessageType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case EMAIL: {
                    return visitor.visitEmail();
                }
                case FACEBOOK: {
                    return visitor.visitFacebook();
                }
                case INAPP: {
                    return visitor.visitInapp();
                }
                case WHATSAPP: {
                    return visitor.visitWhatsapp();
                }
                case SMS: {
                    return visitor.visitSms();
                }
                case TWITTER: {
                    return visitor.visitTwitter();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static MessageType valueOf(String value) {
            switch (value) {
                case "email": {
                    return EMAIL;
                }
                case "facebook": {
                    return FACEBOOK;
                }
                case "inapp": {
                    return INAPP;
                }
                case "whatsapp": {
                    return WHATSAPP;
                }
                case "sms": {
                    return SMS;
                }
                case "twitter": {
                    return TWITTER;
                }
            }
            return new MessageType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitEmail();

            public T visitInapp();

            public T visitFacebook();

            public T visitTwitter();

            public T visitSms();

            public T visitWhatsapp();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            EMAIL,
            INAPP,
            FACEBOOK,
            TWITTER,
            SMS,
            WHATSAPP,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdStage,
    CreatedAtStage,
    BodyStage,
    MessageTypeStage,
    _FinalStage {
        private String type;
        private String id;
        private int createdAt;
        private String body;
        private MessageType messageType;
        private Optional<String> conversationId = Optional.empty();
        private Optional<String> subject = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Message other) {
            this.type(other.getType());
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.subject(other.getSubject());
            this.body(other.getBody());
            this.messageType(other.getMessageType());
            this.conversationId(other.getConversationId());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public BodyStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public MessageTypeStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="message_type")
        public _FinalStage messageType(@NotNull MessageType messageType) {
            this.messageType = Objects.requireNonNull(messageType, "messageType must not be null");
            return this;
        }

        @Override
        public _FinalStage conversationId(String conversationId) {
            this.conversationId = Optional.ofNullable(conversationId);
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id", nulls=Nulls.SKIP)
        public _FinalStage conversationId(Optional<String> conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        @Override
        public _FinalStage subject(String subject) {
            this.subject = Optional.ofNullable(subject);
            return this;
        }

        @Override
        @JsonSetter(value="subject", nulls=Nulls.SKIP)
        public _FinalStage subject(Optional<String> subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this.type, this.id, this.createdAt, this.subject, this.body, this.messageType, this.conversationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Message build();

        public _FinalStage subject(Optional<String> var1);

        public _FinalStage subject(String var1);

        public _FinalStage conversationId(Optional<String> var1);

        public _FinalStage conversationId(String var1);
    }

    public static interface MessageTypeStage {
        public _FinalStage messageType(@NotNull MessageType var1);
    }

    public static interface BodyStage {
        public MessageTypeStage body(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public BodyStage createdAt(int var1);
    }

    public static interface IdStage {
        public CreatedAtStage id(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull String var1);

        public Builder from(Message var1);
    }
}

