/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.notes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.notes.AsyncRawNotesClient;
import com.intercom.api.resources.unstable.notes.requests.CreateNoteRequest;
import com.intercom.api.resources.unstable.notes.requests.ListCompanyNotesRequest;
import com.intercom.api.resources.unstable.notes.requests.ListNotesRequest;
import com.intercom.api.resources.unstable.notes.requests.RetrieveNoteRequest;
import com.intercom.api.resources.unstable.notes.types.Note;
import com.intercom.api.resources.unstable.types.NoteList;
import java.util.concurrent.CompletableFuture;

public class AsyncNotesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawNotesClient rawClient;

    public AsyncNotesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawNotesClient(clientOptions);
    }

    public AsyncRawNotesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<NoteList> listCompanyNotes(ListCompanyNotesRequest request) {
        return this.rawClient.listCompanyNotes(request).thenApply(response -> (NoteList)response.body());
    }

    public CompletableFuture<NoteList> listCompanyNotes(ListCompanyNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyNotes(request, requestOptions).thenApply(response -> (NoteList)response.body());
    }

    public CompletableFuture<NoteList> listNotes(ListNotesRequest request) {
        return this.rawClient.listNotes(request).thenApply(response -> (NoteList)response.body());
    }

    public CompletableFuture<NoteList> listNotes(ListNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listNotes(request, requestOptions).thenApply(response -> (NoteList)response.body());
    }

    public CompletableFuture<Note> createNote(CreateNoteRequest request) {
        return this.rawClient.createNote(request).thenApply(response -> (Note)response.body());
    }

    public CompletableFuture<Note> createNote(CreateNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.createNote(request, requestOptions).thenApply(response -> (Note)response.body());
    }

    public CompletableFuture<Note> retrieveNote(RetrieveNoteRequest request) {
        return this.rawClient.retrieveNote(request).thenApply(response -> (Note)response.body());
    }

    public CompletableFuture<Note> retrieveNote(RetrieveNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNote(request, requestOptions).thenApply(response -> (Note)response.body());
    }
}

