/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.notes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateNoteRequest {
    private final int id;
    private final String body;
    private final Optional<String> contactId;
    private final Optional<String> adminId;
    private final Map<String, Object> additionalProperties;

    private CreateNoteRequest(int id, String body, Optional<String> contactId, Optional<String> adminId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.body = body;
        this.contactId = contactId;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="contact_id")
    public Optional<String> getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="admin_id")
    public Optional<String> getAdminId() {
        return this.adminId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateNoteRequest && this.equalTo((CreateNoteRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateNoteRequest other) {
        return this.id == other.id && this.body.equals(other.body) && this.contactId.equals(other.contactId) && this.adminId.equals(other.adminId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.body, this.contactId, this.adminId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    BodyStage,
    _FinalStage {
        private int id;
        private String body;
        private Optional<String> adminId = Optional.empty();
        private Optional<String> contactId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateNoteRequest other) {
            this.id(other.getId());
            this.body(other.getBody());
            this.contactId(other.getContactId());
            this.adminId(other.getAdminId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public BodyStage id(int id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        @Override
        @JsonSetter(value="admin_id", nulls=Nulls.SKIP)
        public _FinalStage adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        @Override
        public _FinalStage contactId(String contactId) {
            this.contactId = Optional.ofNullable(contactId);
            return this;
        }

        @Override
        @JsonSetter(value="contact_id", nulls=Nulls.SKIP)
        public _FinalStage contactId(Optional<String> contactId) {
            this.contactId = contactId;
            return this;
        }

        @Override
        public CreateNoteRequest build() {
            return new CreateNoteRequest(this.id, this.body, this.contactId, this.adminId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateNoteRequest build();

        public _FinalStage contactId(Optional<String> var1);

        public _FinalStage contactId(String var1);

        public _FinalStage adminId(Optional<String> var1);

        public _FinalStage adminId(String var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull String var1);
    }

    public static interface IdStage {
        public BodyStage id(int var1);

        public Builder from(CreateNoteRequest var1);
    }
}

