/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.tags.types.TagBasic;
import com.intercom.api.resources.unstable.types.ConversationPartAuthor;
import com.intercom.api.resources.unstable.types.ConversationPartMetadata;
import com.intercom.api.resources.unstable.types.EmailMessageMetadata;
import com.intercom.api.resources.unstable.types.EventDetails;
import com.intercom.api.resources.unstable.types.PartAttachment;
import com.intercom.api.resources.unstable.types.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationPart {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> partType;
    private final Optional<String> body;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Integer> notifiedAt;
    private final Optional<Reference> assignedTo;
    private final Optional<ConversationPartAuthor> author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<String> externalId;
    private final Optional<Boolean> redacted;
    private final Optional<EmailMessageMetadata> emailMessageMetadata;
    private final Optional<ConversationPartMetadata> metadata;
    private final Optional<State> state;
    private final Optional<List<TagBasic>> tags;
    private final Optional<EventDetails> eventDetails;
    private final Optional<String> appPackageCode;
    private final Map<String, Object> additionalProperties;

    private ConversationPart(Optional<String> type, Optional<String> id, Optional<String> partType, Optional<String> body, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<Integer> notifiedAt, Optional<Reference> assignedTo, Optional<ConversationPartAuthor> author, Optional<List<PartAttachment>> attachments, Optional<String> externalId, Optional<Boolean> redacted, Optional<EmailMessageMetadata> emailMessageMetadata, Optional<ConversationPartMetadata> metadata, Optional<State> state, Optional<List<TagBasic>> tags, Optional<EventDetails> eventDetails, Optional<String> appPackageCode, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.notifiedAt = notifiedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.emailMessageMetadata = emailMessageMetadata;
        this.metadata = metadata;
        this.state = state;
        this.tags = tags;
        this.eventDetails = eventDetails;
        this.appPackageCode = appPackageCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="part_type")
    public Optional<String> getPartType() {
        return this.partType;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="notified_at")
    public Optional<Integer> getNotifiedAt() {
        return this.notifiedAt;
    }

    @JsonProperty(value="assigned_to")
    public Optional<Reference> getAssignedTo() {
        return this.assignedTo;
    }

    @JsonProperty(value="author")
    public Optional<ConversationPartAuthor> getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="redacted")
    public Optional<Boolean> getRedacted() {
        return this.redacted;
    }

    @JsonProperty(value="email_message_metadata")
    public Optional<EmailMessageMetadata> getEmailMessageMetadata() {
        return this.emailMessageMetadata;
    }

    @JsonProperty(value="metadata")
    public Optional<ConversationPartMetadata> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="tags")
    public Optional<List<TagBasic>> getTags() {
        return this.tags;
    }

    @JsonProperty(value="event_details")
    public Optional<EventDetails> getEventDetails() {
        return this.eventDetails;
    }

    @JsonProperty(value="app_package_code")
    public Optional<String> getAppPackageCode() {
        return this.appPackageCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationPart && this.equalTo((ConversationPart)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPart other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.partType.equals(other.partType) && this.body.equals(other.body) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.notifiedAt.equals(other.notifiedAt) && this.assignedTo.equals(other.assignedTo) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.externalId.equals(other.externalId) && this.redacted.equals(other.redacted) && this.emailMessageMetadata.equals(other.emailMessageMetadata) && this.metadata.equals(other.metadata) && this.state.equals(other.state) && this.tags.equals(other.tags) && this.eventDetails.equals(other.eventDetails) && this.appPackageCode.equals(other.appPackageCode);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.notifiedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.emailMessageMetadata, this.metadata, this.state, this.tags, this.eventDetails, this.appPackageCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class State {
        public static final State SNOOZED = new State(Value.SNOOZED, "snoozed");
        public static final State CLOSED = new State(Value.CLOSED, "closed");
        public static final State OPEN = new State(Value.OPEN, "open");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SNOOZED: {
                    return visitor.visitSnoozed();
                }
                case CLOSED: {
                    return visitor.visitClosed();
                }
                case OPEN: {
                    return visitor.visitOpen();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "snoozed": {
                    return SNOOZED;
                }
                case "closed": {
                    return CLOSED;
                }
                case "open": {
                    return OPEN;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitOpen();

            public T visitClosed();

            public T visitSnoozed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            OPEN,
            CLOSED,
            SNOOZED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> partType = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Integer> notifiedAt = Optional.empty();
        private Optional<Reference> assignedTo = Optional.empty();
        private Optional<ConversationPartAuthor> author = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<Boolean> redacted = Optional.empty();
        private Optional<EmailMessageMetadata> emailMessageMetadata = Optional.empty();
        private Optional<ConversationPartMetadata> metadata = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<List<TagBasic>> tags = Optional.empty();
        private Optional<EventDetails> eventDetails = Optional.empty();
        private Optional<String> appPackageCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationPart other) {
            this.type(other.getType());
            this.id(other.getId());
            this.partType(other.getPartType());
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.notifiedAt(other.getNotifiedAt());
            this.assignedTo(other.getAssignedTo());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.externalId(other.getExternalId());
            this.redacted(other.getRedacted());
            this.emailMessageMetadata(other.getEmailMessageMetadata());
            this.metadata(other.getMetadata());
            this.state(other.getState());
            this.tags(other.getTags());
            this.eventDetails(other.getEventDetails());
            this.appPackageCode(other.getAppPackageCode());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="part_type", nulls=Nulls.SKIP)
        public Builder partType(Optional<String> partType) {
            this.partType = partType;
            return this;
        }

        public Builder partType(String partType) {
            this.partType = Optional.ofNullable(partType);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="notified_at", nulls=Nulls.SKIP)
        public Builder notifiedAt(Optional<Integer> notifiedAt) {
            this.notifiedAt = notifiedAt;
            return this;
        }

        public Builder notifiedAt(Integer notifiedAt) {
            this.notifiedAt = Optional.ofNullable(notifiedAt);
            return this;
        }

        @JsonSetter(value="assigned_to", nulls=Nulls.SKIP)
        public Builder assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        public Builder assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        @JsonSetter(value="author", nulls=Nulls.SKIP)
        public Builder author(Optional<ConversationPartAuthor> author) {
            this.author = author;
            return this;
        }

        public Builder author(ConversationPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public Builder attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @JsonSetter(value="redacted", nulls=Nulls.SKIP)
        public Builder redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        public Builder redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        @JsonSetter(value="email_message_metadata", nulls=Nulls.SKIP)
        public Builder emailMessageMetadata(Optional<EmailMessageMetadata> emailMessageMetadata) {
            this.emailMessageMetadata = emailMessageMetadata;
            return this;
        }

        public Builder emailMessageMetadata(EmailMessageMetadata emailMessageMetadata) {
            this.emailMessageMetadata = Optional.ofNullable(emailMessageMetadata);
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<ConversationPartMetadata> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(ConversationPartMetadata metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<List<TagBasic>> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(List<TagBasic> tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @JsonSetter(value="event_details", nulls=Nulls.SKIP)
        public Builder eventDetails(Optional<EventDetails> eventDetails) {
            this.eventDetails = eventDetails;
            return this;
        }

        public Builder eventDetails(EventDetails eventDetails) {
            this.eventDetails = Optional.ofNullable(eventDetails);
            return this;
        }

        @JsonSetter(value="app_package_code", nulls=Nulls.SKIP)
        public Builder appPackageCode(Optional<String> appPackageCode) {
            this.appPackageCode = appPackageCode;
            return this;
        }

        public Builder appPackageCode(String appPackageCode) {
            this.appPackageCode = Optional.ofNullable(appPackageCode);
            return this;
        }

        public ConversationPart build() {
            return new ConversationPart(this.type, this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.notifiedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.emailMessageMetadata, this.metadata, this.state, this.tags, this.eventDetails, this.appPackageCode, this.additionalProperties);
        }
    }
}

