/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationSlaAppliedByWorkflow {
    private final Optional<String> slaName;
    private final Optional<SlaDefinition> slaDefinition;
    private final Map<String, Object> additionalProperties;

    private ConversationSlaAppliedByWorkflow(Optional<String> slaName, Optional<SlaDefinition> slaDefinition, Map<String, Object> additionalProperties) {
        this.slaName = slaName;
        this.slaDefinition = slaDefinition;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="sla_name")
    public Optional<String> getSlaName() {
        return this.slaName;
    }

    @JsonProperty(value="sla_definition")
    public Optional<SlaDefinition> getSlaDefinition() {
        return this.slaDefinition;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationSlaAppliedByWorkflow && this.equalTo((ConversationSlaAppliedByWorkflow)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationSlaAppliedByWorkflow other) {
        return this.slaName.equals(other.slaName) && this.slaDefinition.equals(other.slaDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.slaName, this.slaDefinition);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class SlaDefinition {
        private final Optional<Integer> firstReplyTime;
        private final Optional<Integer> nextReplyTime;
        private final Optional<Integer> resolutionTime;
        private final Optional<Integer> timeToClose;
        private final Map<String, Object> additionalProperties;

        private SlaDefinition(Optional<Integer> firstReplyTime, Optional<Integer> nextReplyTime, Optional<Integer> resolutionTime, Optional<Integer> timeToClose, Map<String, Object> additionalProperties) {
            this.firstReplyTime = firstReplyTime;
            this.nextReplyTime = nextReplyTime;
            this.resolutionTime = resolutionTime;
            this.timeToClose = timeToClose;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="first_reply_time")
        public Optional<Integer> getFirstReplyTime() {
            return this.firstReplyTime;
        }

        @JsonProperty(value="next_reply_time")
        public Optional<Integer> getNextReplyTime() {
            return this.nextReplyTime;
        }

        @JsonProperty(value="resolution_time")
        public Optional<Integer> getResolutionTime() {
            return this.resolutionTime;
        }

        @JsonProperty(value="time_to_close")
        public Optional<Integer> getTimeToClose() {
            return this.timeToClose;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SlaDefinition && this.equalTo((SlaDefinition)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(SlaDefinition other) {
            return this.firstReplyTime.equals(other.firstReplyTime) && this.nextReplyTime.equals(other.nextReplyTime) && this.resolutionTime.equals(other.resolutionTime) && this.timeToClose.equals(other.timeToClose);
        }

        public int hashCode() {
            return Objects.hash(this.firstReplyTime, this.nextReplyTime, this.resolutionTime, this.timeToClose);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<Integer> firstReplyTime = Optional.empty();
            private Optional<Integer> nextReplyTime = Optional.empty();
            private Optional<Integer> resolutionTime = Optional.empty();
            private Optional<Integer> timeToClose = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(SlaDefinition other) {
                this.firstReplyTime(other.getFirstReplyTime());
                this.nextReplyTime(other.getNextReplyTime());
                this.resolutionTime(other.getResolutionTime());
                this.timeToClose(other.getTimeToClose());
                return this;
            }

            @JsonSetter(value="first_reply_time", nulls=Nulls.SKIP)
            public Builder firstReplyTime(Optional<Integer> firstReplyTime) {
                this.firstReplyTime = firstReplyTime;
                return this;
            }

            public Builder firstReplyTime(Integer firstReplyTime) {
                this.firstReplyTime = Optional.ofNullable(firstReplyTime);
                return this;
            }

            @JsonSetter(value="next_reply_time", nulls=Nulls.SKIP)
            public Builder nextReplyTime(Optional<Integer> nextReplyTime) {
                this.nextReplyTime = nextReplyTime;
                return this;
            }

            public Builder nextReplyTime(Integer nextReplyTime) {
                this.nextReplyTime = Optional.ofNullable(nextReplyTime);
                return this;
            }

            @JsonSetter(value="resolution_time", nulls=Nulls.SKIP)
            public Builder resolutionTime(Optional<Integer> resolutionTime) {
                this.resolutionTime = resolutionTime;
                return this;
            }

            public Builder resolutionTime(Integer resolutionTime) {
                this.resolutionTime = Optional.ofNullable(resolutionTime);
                return this;
            }

            @JsonSetter(value="time_to_close", nulls=Nulls.SKIP)
            public Builder timeToClose(Optional<Integer> timeToClose) {
                this.timeToClose = timeToClose;
                return this;
            }

            public Builder timeToClose(Integer timeToClose) {
                this.timeToClose = Optional.ofNullable(timeToClose);
                return this;
            }

            public SlaDefinition build() {
                return new SlaDefinition(this.firstReplyTime, this.nextReplyTime, this.resolutionTime, this.timeToClose, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> slaName = Optional.empty();
        private Optional<SlaDefinition> slaDefinition = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationSlaAppliedByWorkflow other) {
            this.slaName(other.getSlaName());
            this.slaDefinition(other.getSlaDefinition());
            return this;
        }

        @JsonSetter(value="sla_name", nulls=Nulls.SKIP)
        public Builder slaName(Optional<String> slaName) {
            this.slaName = slaName;
            return this;
        }

        public Builder slaName(String slaName) {
            this.slaName = Optional.ofNullable(slaName);
            return this;
        }

        @JsonSetter(value="sla_definition", nulls=Nulls.SKIP)
        public Builder slaDefinition(Optional<SlaDefinition> slaDefinition) {
            this.slaDefinition = slaDefinition;
            return this;
        }

        public Builder slaDefinition(SlaDefinition slaDefinition) {
            this.slaDefinition = Optional.ofNullable(slaDefinition);
            return this;
        }

        public ConversationSlaAppliedByWorkflow build() {
            return new ConversationSlaAppliedByWorkflow(this.slaName, this.slaDefinition, this.additionalProperties);
        }
    }
}

