/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationTagsUpdated {
    private final Optional<List<String>> tagsAdded;
    private final Optional<List<String>> tagsRemoved;
    private final Map<String, Object> additionalProperties;

    private ConversationTagsUpdated(Optional<List<String>> tagsAdded, Optional<List<String>> tagsRemoved, Map<String, Object> additionalProperties) {
        this.tagsAdded = tagsAdded;
        this.tagsRemoved = tagsRemoved;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="tags_added")
    public Optional<List<String>> getTagsAdded() {
        return this.tagsAdded;
    }

    @JsonProperty(value="tags_removed")
    public Optional<List<String>> getTagsRemoved() {
        return this.tagsRemoved;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationTagsUpdated && this.equalTo((ConversationTagsUpdated)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationTagsUpdated other) {
        return this.tagsAdded.equals(other.tagsAdded) && this.tagsRemoved.equals(other.tagsRemoved);
    }

    public int hashCode() {
        return Objects.hash(this.tagsAdded, this.tagsRemoved);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> tagsAdded = Optional.empty();
        private Optional<List<String>> tagsRemoved = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationTagsUpdated other) {
            this.tagsAdded(other.getTagsAdded());
            this.tagsRemoved(other.getTagsRemoved());
            return this;
        }

        @JsonSetter(value="tags_added", nulls=Nulls.SKIP)
        public Builder tagsAdded(Optional<List<String>> tagsAdded) {
            this.tagsAdded = tagsAdded;
            return this;
        }

        public Builder tagsAdded(List<String> tagsAdded) {
            this.tagsAdded = Optional.ofNullable(tagsAdded);
            return this;
        }

        @JsonSetter(value="tags_removed", nulls=Nulls.SKIP)
        public Builder tagsRemoved(Optional<List<String>> tagsRemoved) {
            this.tagsRemoved = tagsRemoved;
            return this;
        }

        public Builder tagsRemoved(List<String> tagsRemoved) {
            this.tagsRemoved = Optional.ofNullable(tagsRemoved);
            return this;
        }

        public ConversationTagsUpdated build() {
            return new ConversationTagsUpdated(this.tagsAdded, this.tagsRemoved, this.additionalProperties);
        }
    }
}

