/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrUpdateCompanyRequest {
    private final Optional<String> name;
    private final Optional<String> companyId;
    private final Optional<String> plan;
    private final Optional<Integer> size;
    private final Optional<String> website;
    private final Optional<String> industry;
    private final Optional<Map<String, String>> customAttributes;
    private final Optional<Integer> remoteCreatedAt;
    private final Optional<Integer> monthlySpend;
    private final Map<String, Object> additionalProperties;

    private CreateOrUpdateCompanyRequest(Optional<String> name, Optional<String> companyId, Optional<String> plan, Optional<Integer> size, Optional<String> website, Optional<String> industry, Optional<Map<String, String>> customAttributes, Optional<Integer> remoteCreatedAt, Optional<Integer> monthlySpend, Map<String, Object> additionalProperties) {
        this.name = name;
        this.companyId = companyId;
        this.plan = plan;
        this.size = size;
        this.website = website;
        this.industry = industry;
        this.customAttributes = customAttributes;
        this.remoteCreatedAt = remoteCreatedAt;
        this.monthlySpend = monthlySpend;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="plan")
    public Optional<String> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="size")
    public Optional<Integer> getSize() {
        return this.size;
    }

    @JsonProperty(value="website")
    public Optional<String> getWebsite() {
        return this.website;
    }

    @JsonProperty(value="industry")
    public Optional<String> getIndustry() {
        return this.industry;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, String>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<Integer> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="monthly_spend")
    public Optional<Integer> getMonthlySpend() {
        return this.monthlySpend;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrUpdateCompanyRequest && this.equalTo((CreateOrUpdateCompanyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrUpdateCompanyRequest other) {
        return this.name.equals(other.name) && this.companyId.equals(other.companyId) && this.plan.equals(other.plan) && this.size.equals(other.size) && this.website.equals(other.website) && this.industry.equals(other.industry) && this.customAttributes.equals(other.customAttributes) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.monthlySpend.equals(other.monthlySpend);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.companyId, this.plan, this.size, this.website, this.industry, this.customAttributes, this.remoteCreatedAt, this.monthlySpend);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<String> plan = Optional.empty();
        private Optional<Integer> size = Optional.empty();
        private Optional<String> website = Optional.empty();
        private Optional<String> industry = Optional.empty();
        private Optional<Map<String, String>> customAttributes = Optional.empty();
        private Optional<Integer> remoteCreatedAt = Optional.empty();
        private Optional<Integer> monthlySpend = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateOrUpdateCompanyRequest other) {
            this.name(other.getName());
            this.companyId(other.getCompanyId());
            this.plan(other.getPlan());
            this.size(other.getSize());
            this.website(other.getWebsite());
            this.industry(other.getIndustry());
            this.customAttributes(other.getCustomAttributes());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.monthlySpend(other.getMonthlySpend());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public Builder plan(Optional<String> plan) {
            this.plan = plan;
            return this;
        }

        public Builder plan(String plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @JsonSetter(value="size", nulls=Nulls.SKIP)
        public Builder size(Optional<Integer> size) {
            this.size = size;
            return this;
        }

        public Builder size(Integer size) {
            this.size = Optional.ofNullable(size);
            return this;
        }

        @JsonSetter(value="website", nulls=Nulls.SKIP)
        public Builder website(Optional<String> website) {
            this.website = website;
            return this;
        }

        public Builder website(String website) {
            this.website = Optional.ofNullable(website);
            return this;
        }

        @JsonSetter(value="industry", nulls=Nulls.SKIP)
        public Builder industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        public Builder industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public Builder customAttributes(Optional<Map<String, String>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<Integer> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(Integer remoteCreatedAt) {
            this.remoteCreatedAt = Optional.ofNullable(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="monthly_spend", nulls=Nulls.SKIP)
        public Builder monthlySpend(Optional<Integer> monthlySpend) {
            this.monthlySpend = monthlySpend;
            return this;
        }

        public Builder monthlySpend(Integer monthlySpend) {
            this.monthlySpend = Optional.ofNullable(monthlySpend);
            return this;
        }

        public CreateOrUpdateCompanyRequest build() {
            return new CreateOrUpdateCompanyRequest(this.name, this.companyId, this.plan, this.size, this.website, this.industry, this.customAttributes, this.remoteCreatedAt, this.monthlySpend, this.additionalProperties);
        }
    }
}

