/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PriorityChanged {
    private final Optional<CurrentPriority> currentPriority;
    private final Optional<PreviousPriority> previousPriority;
    private final Map<String, Object> additionalProperties;

    private PriorityChanged(Optional<CurrentPriority> currentPriority, Optional<PreviousPriority> previousPriority, Map<String, Object> additionalProperties) {
        this.currentPriority = currentPriority;
        this.previousPriority = previousPriority;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="current_priority")
    public Optional<CurrentPriority> getCurrentPriority() {
        return this.currentPriority;
    }

    @JsonProperty(value="previous_priority")
    public Optional<PreviousPriority> getPreviousPriority() {
        return this.previousPriority;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PriorityChanged && this.equalTo((PriorityChanged)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PriorityChanged other) {
        return this.currentPriority.equals(other.currentPriority) && this.previousPriority.equals(other.previousPriority);
    }

    public int hashCode() {
        return Objects.hash(this.currentPriority, this.previousPriority);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class CurrentPriority {
        public static final CurrentPriority PRIORITY = new CurrentPriority(Value.PRIORITY, "priority");
        public static final CurrentPriority NOT_PRIORITY = new CurrentPriority(Value.NOT_PRIORITY, "not_priority");
        private final Value value;
        private final String string;

        CurrentPriority(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof CurrentPriority && this.string.equals(((CurrentPriority)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PRIORITY: {
                    return visitor.visitPriority();
                }
                case NOT_PRIORITY: {
                    return visitor.visitNotPriority();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static CurrentPriority valueOf(String value) {
            switch (value) {
                case "priority": {
                    return PRIORITY;
                }
                case "not_priority": {
                    return NOT_PRIORITY;
                }
            }
            return new CurrentPriority(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPriority();

            public T visitNotPriority();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PRIORITY,
            NOT_PRIORITY,
            UNKNOWN;

        }
    }

    public static final class PreviousPriority {
        public static final PreviousPriority PRIORITY = new PreviousPriority(Value.PRIORITY, "priority");
        public static final PreviousPriority NOT_PRIORITY = new PreviousPriority(Value.NOT_PRIORITY, "not_priority");
        private final Value value;
        private final String string;

        PreviousPriority(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PreviousPriority && this.string.equals(((PreviousPriority)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PRIORITY: {
                    return visitor.visitPriority();
                }
                case NOT_PRIORITY: {
                    return visitor.visitNotPriority();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static PreviousPriority valueOf(String value) {
            switch (value) {
                case "priority": {
                    return PRIORITY;
                }
                case "not_priority": {
                    return NOT_PRIORITY;
                }
            }
            return new PreviousPriority(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPriority();

            public T visitNotPriority();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PRIORITY,
            NOT_PRIORITY,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CurrentPriority> currentPriority = Optional.empty();
        private Optional<PreviousPriority> previousPriority = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PriorityChanged other) {
            this.currentPriority(other.getCurrentPriority());
            this.previousPriority(other.getPreviousPriority());
            return this;
        }

        @JsonSetter(value="current_priority", nulls=Nulls.SKIP)
        public Builder currentPriority(Optional<CurrentPriority> currentPriority) {
            this.currentPriority = currentPriority;
            return this;
        }

        public Builder currentPriority(CurrentPriority currentPriority) {
            this.currentPriority = Optional.ofNullable(currentPriority);
            return this;
        }

        @JsonSetter(value="previous_priority", nulls=Nulls.SKIP)
        public Builder previousPriority(Optional<PreviousPriority> previousPriority) {
            this.previousPriority = previousPriority;
            return this;
        }

        public Builder previousPriority(PreviousPriority previousPriority) {
            this.previousPriority = Optional.ofNullable(previousPriority);
            return this;
        }

        public PriorityChanged build() {
            return new PriorityChanged(this.currentPriority, this.previousPriority, this.additionalProperties);
        }
    }
}

