/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RegisterFinVoiceCallRequest {
    private final String phoneNumber;
    private final String callId;
    private final Optional<Source> source;
    private final Optional<Map<String, Object>> data;
    private final Map<String, Object> additionalProperties;

    private RegisterFinVoiceCallRequest(String phoneNumber, String callId, Optional<Source> source, Optional<Map<String, Object>> data, Map<String, Object> additionalProperties) {
        this.phoneNumber = phoneNumber;
        this.callId = callId;
        this.source = source;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="phone_number")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="call_id")
    public String getCallId() {
        return this.callId;
    }

    @JsonProperty(value="source")
    public Optional<Source> getSource() {
        return this.source;
    }

    @JsonProperty(value="data")
    public Optional<Map<String, Object>> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RegisterFinVoiceCallRequest && this.equalTo((RegisterFinVoiceCallRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RegisterFinVoiceCallRequest other) {
        return this.phoneNumber.equals(other.phoneNumber) && this.callId.equals(other.callId) && this.source.equals(other.source) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.phoneNumber, this.callId, this.source, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PhoneNumberStage builder() {
        return new Builder();
    }

    public static final class Source {
        public static final Source ZOOM_PHONE = new Source(Value.ZOOM_PHONE, "zoom_phone");
        public static final Source AWS_CONNECT = new Source(Value.AWS_CONNECT, "aws_connect");
        public static final Source FIVE_9 = new Source(Value.FIVE_9, "five9");
        private final Value value;
        private final String string;

        Source(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Source && this.string.equals(((Source)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case ZOOM_PHONE: {
                    return visitor.visitZoomPhone();
                }
                case AWS_CONNECT: {
                    return visitor.visitAwsConnect();
                }
                case FIVE_9: {
                    return visitor.visitFive9();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Source valueOf(String value) {
            switch (value) {
                case "zoom_phone": {
                    return ZOOM_PHONE;
                }
                case "aws_connect": {
                    return AWS_CONNECT;
                }
                case "five9": {
                    return FIVE_9;
                }
            }
            return new Source(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitFive9();

            public T visitZoomPhone();

            public T visitAwsConnect();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            FIVE_9,
            ZOOM_PHONE,
            AWS_CONNECT,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PhoneNumberStage,
    CallIdStage,
    _FinalStage {
        private String phoneNumber;
        private String callId;
        private Optional<Map<String, Object>> data = Optional.empty();
        private Optional<Source> source = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RegisterFinVoiceCallRequest other) {
            this.phoneNumber(other.getPhoneNumber());
            this.callId(other.getCallId());
            this.source(other.getSource());
            this.data(other.getData());
            return this;
        }

        @Override
        @JsonSetter(value="phone_number")
        public CallIdStage phoneNumber(@NotNull String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="call_id")
        public _FinalStage callId(@NotNull String callId) {
            this.callId = Objects.requireNonNull(callId, "callId must not be null");
            return this;
        }

        @Override
        public _FinalStage data(Map<String, Object> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(Optional<Map<String, Object>> data) {
            this.data = data;
            return this;
        }

        @Override
        public _FinalStage source(Source source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @Override
        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public _FinalStage source(Optional<Source> source) {
            this.source = source;
            return this;
        }

        @Override
        public RegisterFinVoiceCallRequest build() {
            return new RegisterFinVoiceCallRequest(this.phoneNumber, this.callId, this.source, this.data, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RegisterFinVoiceCallRequest build();

        public _FinalStage source(Optional<Source> var1);

        public _FinalStage source(Source var1);

        public _FinalStage data(Optional<Map<String, Object>> var1);

        public _FinalStage data(Map<String, Object> var1);
    }

    public static interface CallIdStage {
        public _FinalStage callId(@NotNull String var1);
    }

    public static interface PhoneNumberStage {
        public CallIdStage phoneNumber(@NotNull String var1);

        public Builder from(RegisterFinVoiceCallRequest var1);
    }
}

