/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.MultipleFilterSearchRequest;
import com.intercom.api.resources.unstable.types.SingleFilterSearchRequest;
import com.intercom.api.resources.unstable.types.StartingAfterPaging;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchRequest {
    private final Query query;
    private final Optional<StartingAfterPaging> pagination;
    private final Map<String, Object> additionalProperties;

    private SearchRequest(Query query, Optional<StartingAfterPaging> pagination, Map<String, Object> additionalProperties) {
        this.query = query;
        this.pagination = pagination;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="query")
    public Query getQuery() {
        return this.query;
    }

    @JsonProperty(value="pagination")
    public Optional<StartingAfterPaging> getPagination() {
        return this.pagination;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchRequest && this.equalTo((SearchRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchRequest other) {
        return this.query.equals(other.query) && this.pagination.equals(other.pagination);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.pagination);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QueryStage builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class Query {
        private final Object value;
        private final int type;

        private Query(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((SingleFilterSearchRequest)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((MultipleFilterSearchRequest)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Query && this.equalTo((Query)other);
        }

        private boolean equalTo(Query other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static Query of(SingleFilterSearchRequest value) {
            return new Query(value, 0);
        }

        public static Query of(MultipleFilterSearchRequest value) {
            return new Query(value, 1);
        }

        static final class Deserializer
        extends StdDeserializer<Query> {
            Deserializer() {
                super(Query.class);
            }

            public Query deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return Query.of((SingleFilterSearchRequest)ObjectMappers.JSON_MAPPER.convertValue(value, SingleFilterSearchRequest.class));
                }
                catch (RuntimeException runtimeException) {
                    try {
                        return Query.of((MultipleFilterSearchRequest)ObjectMappers.JSON_MAPPER.convertValue(value, MultipleFilterSearchRequest.class));
                    }
                    catch (RuntimeException runtimeException2) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(SingleFilterSearchRequest var1);

            public T visit(MultipleFilterSearchRequest var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QueryStage,
    _FinalStage {
        private Query query;
        private Optional<StartingAfterPaging> pagination = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchRequest other) {
            this.query(other.getQuery());
            this.pagination(other.getPagination());
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public _FinalStage query(@NotNull Query query) {
            this.query = Objects.requireNonNull(query, "query must not be null");
            return this;
        }

        @Override
        public _FinalStage pagination(StartingAfterPaging pagination) {
            this.pagination = Optional.ofNullable(pagination);
            return this;
        }

        @Override
        @JsonSetter(value="pagination", nulls=Nulls.SKIP)
        public _FinalStage pagination(Optional<StartingAfterPaging> pagination) {
            this.pagination = pagination;
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this.query, this.pagination, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchRequest build();

        public _FinalStage pagination(Optional<StartingAfterPaging> var1);

        public _FinalStage pagination(StartingAfterPaging var1);
    }

    public static interface QueryStage {
        public _FinalStage query(@NotNull Query var1);

        public Builder from(SearchRequest var1);
    }
}

