/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class WorkflowExport {
    private final Optional<String> exportVersion;
    private final Optional<OffsetDateTime> exportedAt;
    private final Optional<Integer> appId;
    private final Optional<Workflow> workflow;
    private final Map<String, Object> additionalProperties;

    private WorkflowExport(Optional<String> exportVersion, Optional<OffsetDateTime> exportedAt, Optional<Integer> appId, Optional<Workflow> workflow, Map<String, Object> additionalProperties) {
        this.exportVersion = exportVersion;
        this.exportedAt = exportedAt;
        this.appId = appId;
        this.workflow = workflow;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="export_version")
    public Optional<String> getExportVersion() {
        return this.exportVersion;
    }

    @JsonProperty(value="exported_at")
    public Optional<OffsetDateTime> getExportedAt() {
        return this.exportedAt;
    }

    @JsonProperty(value="app_id")
    public Optional<Integer> getAppId() {
        return this.appId;
    }

    @JsonProperty(value="workflow")
    public Optional<Workflow> getWorkflow() {
        return this.workflow;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WorkflowExport && this.equalTo((WorkflowExport)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WorkflowExport other) {
        return this.exportVersion.equals(other.exportVersion) && this.exportedAt.equals(other.exportedAt) && this.appId.equals(other.appId) && this.workflow.equals(other.workflow);
    }

    public int hashCode() {
        return Objects.hash(this.exportVersion, this.exportedAt, this.appId, this.workflow);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Workflow {
        private final Optional<String> id;
        private final Optional<String> title;
        private final Optional<String> description;
        private final Optional<String> triggerType;
        private final Optional<State> state;
        private final Optional<List<String>> targetChannels;
        private final Optional<List<String>> preferredDevices;
        private final Optional<OffsetDateTime> createdAt;
        private final Optional<OffsetDateTime> updatedAt;
        private final Optional<Map<String, Object>> targeting;
        private final Optional<Map<String, Object>> snapshot;
        private final Optional<List<Map<String, Object>>> attributes;
        private final Optional<List<Map<String, Object>>> embeddedRules;
        private final Map<String, Object> additionalProperties;

        private Workflow(Optional<String> id, Optional<String> title, Optional<String> description, Optional<String> triggerType, Optional<State> state, Optional<List<String>> targetChannels, Optional<List<String>> preferredDevices, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt, Optional<Map<String, Object>> targeting, Optional<Map<String, Object>> snapshot, Optional<List<Map<String, Object>>> attributes, Optional<List<Map<String, Object>>> embeddedRules, Map<String, Object> additionalProperties) {
            this.id = id;
            this.title = title;
            this.description = description;
            this.triggerType = triggerType;
            this.state = state;
            this.targetChannels = targetChannels;
            this.preferredDevices = preferredDevices;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.targeting = targeting;
            this.snapshot = snapshot;
            this.attributes = attributes;
            this.embeddedRules = embeddedRules;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="id")
        public Optional<String> getId() {
            return this.id;
        }

        @JsonProperty(value="title")
        public Optional<String> getTitle() {
            return this.title;
        }

        @JsonProperty(value="description")
        public Optional<String> getDescription() {
            return this.description;
        }

        @JsonProperty(value="trigger_type")
        public Optional<String> getTriggerType() {
            return this.triggerType;
        }

        @JsonProperty(value="state")
        public Optional<State> getState() {
            return this.state;
        }

        @JsonProperty(value="target_channels")
        public Optional<List<String>> getTargetChannels() {
            return this.targetChannels;
        }

        @JsonProperty(value="preferred_devices")
        public Optional<List<String>> getPreferredDevices() {
            return this.preferredDevices;
        }

        @JsonProperty(value="created_at")
        public Optional<OffsetDateTime> getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="updated_at")
        public Optional<OffsetDateTime> getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="targeting")
        public Optional<Map<String, Object>> getTargeting() {
            return this.targeting;
        }

        @JsonProperty(value="snapshot")
        public Optional<Map<String, Object>> getSnapshot() {
            return this.snapshot;
        }

        @JsonProperty(value="attributes")
        public Optional<List<Map<String, Object>>> getAttributes() {
            return this.attributes;
        }

        @JsonProperty(value="embedded_rules")
        public Optional<List<Map<String, Object>>> getEmbeddedRules() {
            return this.embeddedRules;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Workflow && this.equalTo((Workflow)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Workflow other) {
            return this.id.equals(other.id) && this.title.equals(other.title) && this.description.equals(other.description) && this.triggerType.equals(other.triggerType) && this.state.equals(other.state) && this.targetChannels.equals(other.targetChannels) && this.preferredDevices.equals(other.preferredDevices) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.targeting.equals(other.targeting) && this.snapshot.equals(other.snapshot) && this.attributes.equals(other.attributes) && this.embeddedRules.equals(other.embeddedRules);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.title, this.description, this.triggerType, this.state, this.targetChannels, this.preferredDevices, this.createdAt, this.updatedAt, this.targeting, this.snapshot, this.attributes, this.embeddedRules);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class State {
            public static final State LIVE = new State(Value.LIVE, "live");
            public static final State PAUSED = new State(Value.PAUSED, "paused");
            public static final State DRAFT = new State(Value.DRAFT, "draft");
            private final Value value;
            private final String string;

            State(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return this.value;
            }

            @JsonValue
            public String toString() {
                return this.string;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof State && this.string.equals(((State)other).string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (this.value) {
                    case LIVE: {
                        return visitor.visitLive();
                    }
                    case PAUSED: {
                        return visitor.visitPaused();
                    }
                    case DRAFT: {
                        return visitor.visitDraft();
                    }
                }
                return visitor.visitUnknown(this.string);
            }

            @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
            public static State valueOf(String value) {
                switch (value) {
                    case "live": {
                        return LIVE;
                    }
                    case "paused": {
                        return PAUSED;
                    }
                    case "draft": {
                        return DRAFT;
                    }
                }
                return new State(Value.UNKNOWN, value);
            }

            public static interface Visitor<T> {
                public T visitLive();

                public T visitDraft();

                public T visitPaused();

                public T visitUnknown(String var1);
            }

            public static enum Value {
                LIVE,
                DRAFT,
                PAUSED,
                UNKNOWN;

            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> id = Optional.empty();
            private Optional<String> title = Optional.empty();
            private Optional<String> description = Optional.empty();
            private Optional<String> triggerType = Optional.empty();
            private Optional<State> state = Optional.empty();
            private Optional<List<String>> targetChannels = Optional.empty();
            private Optional<List<String>> preferredDevices = Optional.empty();
            private Optional<OffsetDateTime> createdAt = Optional.empty();
            private Optional<OffsetDateTime> updatedAt = Optional.empty();
            private Optional<Map<String, Object>> targeting = Optional.empty();
            private Optional<Map<String, Object>> snapshot = Optional.empty();
            private Optional<List<Map<String, Object>>> attributes = Optional.empty();
            private Optional<List<Map<String, Object>>> embeddedRules = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Workflow other) {
                this.id(other.getId());
                this.title(other.getTitle());
                this.description(other.getDescription());
                this.triggerType(other.getTriggerType());
                this.state(other.getState());
                this.targetChannels(other.getTargetChannels());
                this.preferredDevices(other.getPreferredDevices());
                this.createdAt(other.getCreatedAt());
                this.updatedAt(other.getUpdatedAt());
                this.targeting(other.getTargeting());
                this.snapshot(other.getSnapshot());
                this.attributes(other.getAttributes());
                this.embeddedRules(other.getEmbeddedRules());
                return this;
            }

            @JsonSetter(value="id", nulls=Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            @JsonSetter(value="title", nulls=Nulls.SKIP)
            public Builder title(Optional<String> title) {
                this.title = title;
                return this;
            }

            public Builder title(String title) {
                this.title = Optional.ofNullable(title);
                return this;
            }

            @JsonSetter(value="description", nulls=Nulls.SKIP)
            public Builder description(Optional<String> description) {
                this.description = description;
                return this;
            }

            public Builder description(String description) {
                this.description = Optional.ofNullable(description);
                return this;
            }

            @JsonSetter(value="trigger_type", nulls=Nulls.SKIP)
            public Builder triggerType(Optional<String> triggerType) {
                this.triggerType = triggerType;
                return this;
            }

            public Builder triggerType(String triggerType) {
                this.triggerType = Optional.ofNullable(triggerType);
                return this;
            }

            @JsonSetter(value="state", nulls=Nulls.SKIP)
            public Builder state(Optional<State> state) {
                this.state = state;
                return this;
            }

            public Builder state(State state) {
                this.state = Optional.ofNullable(state);
                return this;
            }

            @JsonSetter(value="target_channels", nulls=Nulls.SKIP)
            public Builder targetChannels(Optional<List<String>> targetChannels) {
                this.targetChannels = targetChannels;
                return this;
            }

            public Builder targetChannels(List<String> targetChannels) {
                this.targetChannels = Optional.ofNullable(targetChannels);
                return this;
            }

            @JsonSetter(value="preferred_devices", nulls=Nulls.SKIP)
            public Builder preferredDevices(Optional<List<String>> preferredDevices) {
                this.preferredDevices = preferredDevices;
                return this;
            }

            public Builder preferredDevices(List<String> preferredDevices) {
                this.preferredDevices = Optional.ofNullable(preferredDevices);
                return this;
            }

            @JsonSetter(value="created_at", nulls=Nulls.SKIP)
            public Builder createdAt(Optional<OffsetDateTime> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public Builder createdAt(OffsetDateTime createdAt) {
                this.createdAt = Optional.ofNullable(createdAt);
                return this;
            }

            @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
            public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Builder updatedAt(OffsetDateTime updatedAt) {
                this.updatedAt = Optional.ofNullable(updatedAt);
                return this;
            }

            @JsonSetter(value="targeting", nulls=Nulls.SKIP)
            public Builder targeting(Optional<Map<String, Object>> targeting) {
                this.targeting = targeting;
                return this;
            }

            public Builder targeting(Map<String, Object> targeting) {
                this.targeting = Optional.ofNullable(targeting);
                return this;
            }

            @JsonSetter(value="snapshot", nulls=Nulls.SKIP)
            public Builder snapshot(Optional<Map<String, Object>> snapshot) {
                this.snapshot = snapshot;
                return this;
            }

            public Builder snapshot(Map<String, Object> snapshot) {
                this.snapshot = Optional.ofNullable(snapshot);
                return this;
            }

            @JsonSetter(value="attributes", nulls=Nulls.SKIP)
            public Builder attributes(Optional<List<Map<String, Object>>> attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder attributes(List<Map<String, Object>> attributes) {
                this.attributes = Optional.ofNullable(attributes);
                return this;
            }

            @JsonSetter(value="embedded_rules", nulls=Nulls.SKIP)
            public Builder embeddedRules(Optional<List<Map<String, Object>>> embeddedRules) {
                this.embeddedRules = embeddedRules;
                return this;
            }

            public Builder embeddedRules(List<Map<String, Object>> embeddedRules) {
                this.embeddedRules = Optional.ofNullable(embeddedRules);
                return this;
            }

            public Workflow build() {
                return new Workflow(this.id, this.title, this.description, this.triggerType, this.state, this.targetChannels, this.preferredDevices, this.createdAt, this.updatedAt, this.targeting, this.snapshot, this.attributes, this.embeddedRules, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> exportVersion = Optional.empty();
        private Optional<OffsetDateTime> exportedAt = Optional.empty();
        private Optional<Integer> appId = Optional.empty();
        private Optional<Workflow> workflow = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(WorkflowExport other) {
            this.exportVersion(other.getExportVersion());
            this.exportedAt(other.getExportedAt());
            this.appId(other.getAppId());
            this.workflow(other.getWorkflow());
            return this;
        }

        @JsonSetter(value="export_version", nulls=Nulls.SKIP)
        public Builder exportVersion(Optional<String> exportVersion) {
            this.exportVersion = exportVersion;
            return this;
        }

        public Builder exportVersion(String exportVersion) {
            this.exportVersion = Optional.ofNullable(exportVersion);
            return this;
        }

        @JsonSetter(value="exported_at", nulls=Nulls.SKIP)
        public Builder exportedAt(Optional<OffsetDateTime> exportedAt) {
            this.exportedAt = exportedAt;
            return this;
        }

        public Builder exportedAt(OffsetDateTime exportedAt) {
            this.exportedAt = Optional.ofNullable(exportedAt);
            return this;
        }

        @JsonSetter(value="app_id", nulls=Nulls.SKIP)
        public Builder appId(Optional<Integer> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(Integer appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @JsonSetter(value="workflow", nulls=Nulls.SKIP)
        public Builder workflow(Optional<Workflow> workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = Optional.ofNullable(workflow);
            return this;
        }

        public WorkflowExport build() {
            return new WorkflowExport(this.exportVersion, this.exportedAt, this.appId, this.workflow, this.additionalProperties);
        }
    }
}

