/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.visitors;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.contacts.types.Contact;
import com.intercom.api.resources.unstable.types.Visitor;
import com.intercom.api.resources.unstable.visitors.AsyncRawVisitorsClient;
import com.intercom.api.resources.unstable.visitors.requests.ConvertVisitorRequest;
import com.intercom.api.resources.unstable.visitors.requests.RetrieveVisitorWithUserIdRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncVisitorsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawVisitorsClient rawClient;

    public AsyncVisitorsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawVisitorsClient(clientOptions);
    }

    public AsyncRawVisitorsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Optional<Visitor>> retrieveVisitorWithUserId(RetrieveVisitorWithUserIdRequest request) {
        return this.rawClient.retrieveVisitorWithUserId(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Visitor>> retrieveVisitorWithUserId(RetrieveVisitorWithUserIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveVisitorWithUserId(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Visitor>> updateVisitor(Object request) {
        return this.rawClient.updateVisitor(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Visitor>> updateVisitor(Object request, RequestOptions requestOptions) {
        return this.rawClient.updateVisitor(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Contact> convertVisitor(ConvertVisitorRequest request) {
        return this.rawClient.convertVisitor(request).thenApply(response -> (Contact)response.body());
    }

    public CompletableFuture<Contact> convertVisitor(ConvertVisitorRequest request, RequestOptions requestOptions) {
        return this.rawClient.convertVisitor(request, requestOptions).thenApply(response -> (Contact)response.body());
    }
}

