/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ArticleStatistics {
    private final int views;
    private final Optional<Integer> conversions;
    private final int reactions;
    private final float happyReactionPercentage;
    private final float neutralReactionPercentage;
    private final float sadReactionPercentage;
    private final Map<String, Object> additionalProperties;

    private ArticleStatistics(int views, Optional<Integer> conversions, int reactions, float happyReactionPercentage, float neutralReactionPercentage, float sadReactionPercentage, Map<String, Object> additionalProperties) {
        this.views = views;
        this.conversions = conversions;
        this.reactions = reactions;
        this.happyReactionPercentage = happyReactionPercentage;
        this.neutralReactionPercentage = neutralReactionPercentage;
        this.sadReactionPercentage = sadReactionPercentage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "article_statistics";
    }

    @JsonProperty(value="views")
    public int getViews() {
        return this.views;
    }

    @JsonProperty(value="conversions")
    public Optional<Integer> getConversions() {
        return this.conversions;
    }

    @JsonProperty(value="reactions")
    public int getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="happy_reaction_percentage")
    public float getHappyReactionPercentage() {
        return this.happyReactionPercentage;
    }

    @JsonProperty(value="neutral_reaction_percentage")
    public float getNeutralReactionPercentage() {
        return this.neutralReactionPercentage;
    }

    @JsonProperty(value="sad_reaction_percentage")
    public float getSadReactionPercentage() {
        return this.sadReactionPercentage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ArticleStatistics && this.equalTo((ArticleStatistics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleStatistics other) {
        return this.views == other.views && this.conversions.equals(other.conversions) && this.reactions == other.reactions && this.happyReactionPercentage == other.happyReactionPercentage && this.neutralReactionPercentage == other.neutralReactionPercentage && this.sadReactionPercentage == other.sadReactionPercentage;
    }

    public int hashCode() {
        return Objects.hash(this.views, this.conversions, this.reactions, Float.valueOf(this.happyReactionPercentage), Float.valueOf(this.neutralReactionPercentage), Float.valueOf(this.sadReactionPercentage));
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ViewsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ViewsStage,
    ReactionsStage,
    HappyReactionPercentageStage,
    NeutralReactionPercentageStage,
    SadReactionPercentageStage,
    _FinalStage {
        private int views;
        private int reactions;
        private float happyReactionPercentage;
        private float neutralReactionPercentage;
        private float sadReactionPercentage;
        private Optional<Integer> conversions = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ArticleStatistics other) {
            this.views(other.getViews());
            this.conversions(other.getConversions());
            this.reactions(other.getReactions());
            this.happyReactionPercentage(other.getHappyReactionPercentage());
            this.neutralReactionPercentage(other.getNeutralReactionPercentage());
            this.sadReactionPercentage(other.getSadReactionPercentage());
            return this;
        }

        @Override
        @JsonSetter(value="views")
        public ReactionsStage views(int views) {
            this.views = views;
            return this;
        }

        @Override
        @JsonSetter(value="reactions")
        public HappyReactionPercentageStage reactions(int reactions) {
            this.reactions = reactions;
            return this;
        }

        @Override
        @JsonSetter(value="happy_reaction_percentage")
        public NeutralReactionPercentageStage happyReactionPercentage(float happyReactionPercentage) {
            this.happyReactionPercentage = happyReactionPercentage;
            return this;
        }

        @Override
        @JsonSetter(value="neutral_reaction_percentage")
        public SadReactionPercentageStage neutralReactionPercentage(float neutralReactionPercentage) {
            this.neutralReactionPercentage = neutralReactionPercentage;
            return this;
        }

        @Override
        @JsonSetter(value="sad_reaction_percentage")
        public _FinalStage sadReactionPercentage(float sadReactionPercentage) {
            this.sadReactionPercentage = sadReactionPercentage;
            return this;
        }

        @Override
        public _FinalStage conversions(Integer conversions) {
            this.conversions = Optional.ofNullable(conversions);
            return this;
        }

        @Override
        @JsonSetter(value="conversions", nulls=Nulls.SKIP)
        public _FinalStage conversions(Optional<Integer> conversions) {
            this.conversions = conversions;
            return this;
        }

        @Override
        public ArticleStatistics build() {
            return new ArticleStatistics(this.views, this.conversions, this.reactions, this.happyReactionPercentage, this.neutralReactionPercentage, this.sadReactionPercentage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ArticleStatistics build();

        public _FinalStage conversions(Optional<Integer> var1);

        public _FinalStage conversions(Integer var1);
    }

    public static interface SadReactionPercentageStage {
        public _FinalStage sadReactionPercentage(float var1);
    }

    public static interface NeutralReactionPercentageStage {
        public SadReactionPercentageStage neutralReactionPercentage(float var1);
    }

    public static interface HappyReactionPercentageStage {
        public NeutralReactionPercentageStage happyReactionPercentage(float var1);
    }

    public static interface ReactionsStage {
        public HappyReactionPercentageStage reactions(int var1);
    }

    public static interface ViewsStage {
        public ReactionsStage views(int var1);

        public Builder from(ArticleStatistics var1);
    }
}

