/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.calls.types.Call;
import com.intercom.api.types.CursorPages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CallList {
    private final Optional<String> type;
    private final Optional<List<Call>> data;
    private final Optional<Integer> totalCount;
    private final Optional<CursorPages> pages;
    private final Map<String, Object> additionalProperties;

    private CallList(Optional<String> type, Optional<List<Call>> data, Optional<Integer> totalCount, Optional<CursorPages> pages, Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="data")
    public Optional<List<Call>> getData() {
        return this.data;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CallList && this.equalTo((CallList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CallList other) {
        return this.type.equals(other.type) && this.data.equals(other.data) && this.totalCount.equals(other.totalCount) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data, this.totalCount, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Call>> data = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<CursorPages> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CallList other) {
            this.type(other.getType());
            this.data(other.getData());
            this.totalCount(other.getTotalCount());
            this.pages(other.getPages());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<Call>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Call> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public CallList build() {
            return new CallList(this.type, this.data, this.totalCount, this.pages, this.additionalProperties);
        }
    }
}

