/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.types.PagesLink;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactAttachedCompanies {
    private final Optional<String> type;
    private final Optional<List<Company>> companies;
    private final Optional<Integer> totalCount;
    private final Optional<PagesLink> pages;
    private final Map<String, Object> additionalProperties;

    private ContactAttachedCompanies(Optional<String> type, Optional<List<Company>> companies, Optional<Integer> totalCount, Optional<PagesLink> pages, Map<String, Object> additionalProperties) {
        this.type = type;
        this.companies = companies;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="companies")
    public Optional<List<Company>> getCompanies() {
        return this.companies;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="pages")
    public Optional<PagesLink> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactAttachedCompanies && this.equalTo((ContactAttachedCompanies)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactAttachedCompanies other) {
        return this.type.equals(other.type) && this.companies.equals(other.companies) && this.totalCount.equals(other.totalCount) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.companies, this.totalCount, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Company>> companies = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<PagesLink> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContactAttachedCompanies other) {
            this.type(other.getType());
            this.companies(other.getCompanies());
            this.totalCount(other.getTotalCount());
            this.pages(other.getPages());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="companies", nulls=Nulls.SKIP)
        public Builder companies(Optional<List<Company>> companies) {
            this.companies = companies;
            return this;
        }

        public Builder companies(List<Company> companies) {
            this.companies = Optional.ofNullable(companies);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<PagesLink> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(PagesLink pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public ContactAttachedCompanies build() {
            return new ContactAttachedCompanies(this.type, this.companies, this.totalCount, this.pages, this.additionalProperties);
        }
    }
}

