/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.IContactReplyBaseRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactReplyTicketIntercomUserIdRequest
implements IContactReplyBaseRequest {
    private final String body;
    private final Optional<Integer> createdAt;
    private final Optional<List<String>> attachmentUrls;
    private final Optional<List<ReplyOptionsItem>> replyOptions;
    private final String intercomUserId;
    private final Map<String, Object> additionalProperties;

    private ContactReplyTicketIntercomUserIdRequest(String body, Optional<Integer> createdAt, Optional<List<String>> attachmentUrls, Optional<List<ReplyOptionsItem>> replyOptions, String intercomUserId, Map<String, Object> additionalProperties) {
        this.body = body;
        this.createdAt = createdAt;
        this.attachmentUrls = attachmentUrls;
        this.replyOptions = replyOptions;
        this.intercomUserId = intercomUserId;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="message_type")
    public String getMessageType() {
        return "comment";
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return "user";
    }

    @Override
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="attachment_urls")
    public Optional<List<String>> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    @JsonProperty(value="reply_options")
    public Optional<List<ReplyOptionsItem>> getReplyOptions() {
        return this.replyOptions;
    }

    @JsonProperty(value="intercom_user_id")
    public String getIntercomUserId() {
        return this.intercomUserId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactReplyTicketIntercomUserIdRequest && this.equalTo((ContactReplyTicketIntercomUserIdRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactReplyTicketIntercomUserIdRequest other) {
        return this.body.equals(other.body) && this.createdAt.equals(other.createdAt) && this.attachmentUrls.equals(other.attachmentUrls) && this.replyOptions.equals(other.replyOptions) && this.intercomUserId.equals(other.intercomUserId);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.createdAt, this.attachmentUrls, this.replyOptions, this.intercomUserId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class ReplyOptionsItem {
        private final String text;
        private final String uuid;
        private final Map<String, Object> additionalProperties;

        private ReplyOptionsItem(String text, String uuid, Map<String, Object> additionalProperties) {
            this.text = text;
            this.uuid = uuid;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="uuid")
        public String getUuid() {
            return this.uuid;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ReplyOptionsItem && this.equalTo((ReplyOptionsItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ReplyOptionsItem other) {
            return this.text.equals(other.text) && this.uuid.equals(other.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.uuid);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static TextStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements TextStage,
        UuidStage,
        _FinalStage {
            private String text;
            private String uuid;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(ReplyOptionsItem other) {
                this.text(other.getText());
                this.uuid(other.getUuid());
                return this;
            }

            @Override
            @JsonSetter(value="text")
            public UuidStage text(@NotNull String text) {
                this.text = Objects.requireNonNull(text, "text must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="uuid")
            public _FinalStage uuid(@NotNull String uuid) {
                this.uuid = Objects.requireNonNull(uuid, "uuid must not be null");
                return this;
            }

            @Override
            public ReplyOptionsItem build() {
                return new ReplyOptionsItem(this.text, this.uuid, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public ReplyOptionsItem build();
        }

        public static interface UuidStage {
            public _FinalStage uuid(@NotNull String var1);
        }

        public static interface TextStage {
            public UuidStage text(@NotNull String var1);

            public Builder from(ReplyOptionsItem var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BodyStage,
    IntercomUserIdStage,
    _FinalStage {
        private String body;
        private String intercomUserId;
        private Optional<List<ReplyOptionsItem>> replyOptions = Optional.empty();
        private Optional<List<String>> attachmentUrls = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactReplyTicketIntercomUserIdRequest other) {
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.attachmentUrls(other.getAttachmentUrls());
            this.replyOptions(other.getReplyOptions());
            this.intercomUserId(other.getIntercomUserId());
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public IntercomUserIdStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="intercom_user_id")
        public _FinalStage intercomUserId(@NotNull String intercomUserId) {
            this.intercomUserId = Objects.requireNonNull(intercomUserId, "intercomUserId must not be null");
            return this;
        }

        @Override
        public _FinalStage replyOptions(List<ReplyOptionsItem> replyOptions) {
            this.replyOptions = Optional.ofNullable(replyOptions);
            return this;
        }

        @Override
        @JsonSetter(value="reply_options", nulls=Nulls.SKIP)
        public _FinalStage replyOptions(Optional<List<ReplyOptionsItem>> replyOptions) {
            this.replyOptions = replyOptions;
            return this;
        }

        @Override
        public _FinalStage attachmentUrls(List<String> attachmentUrls) {
            this.attachmentUrls = Optional.ofNullable(attachmentUrls);
            return this;
        }

        @Override
        @JsonSetter(value="attachment_urls", nulls=Nulls.SKIP)
        public _FinalStage attachmentUrls(Optional<List<String>> attachmentUrls) {
            this.attachmentUrls = attachmentUrls;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public ContactReplyTicketIntercomUserIdRequest build() {
            return new ContactReplyTicketIntercomUserIdRequest(this.body, this.createdAt, this.attachmentUrls, this.replyOptions, this.intercomUserId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactReplyTicketIntercomUserIdRequest build();

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage attachmentUrls(Optional<List<String>> var1);

        public _FinalStage attachmentUrls(List<String> var1);

        public _FinalStage replyOptions(Optional<List<ReplyOptionsItem>> var1);

        public _FinalStage replyOptions(List<ReplyOptionsItem> var1);
    }

    public static interface IntercomUserIdStage {
        public _FinalStage intercomUserId(@NotNull String var1);
    }

    public static interface BodyStage {
        public IntercomUserIdStage body(@NotNull String var1);

        public Builder from(ContactReplyTicketIntercomUserIdRequest var1);
    }
}

