/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.conversations.types.Conversation;
import com.intercom.api.types.CursorPages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationList {
    private final Optional<String> type;
    private final Optional<List<Conversation>> conversations;
    private final Optional<Integer> totalCount;
    private final Optional<CursorPages> pages;
    private final Map<String, Object> additionalProperties;

    private ConversationList(Optional<String> type, Optional<List<Conversation>> conversations, Optional<Integer> totalCount, Optional<CursorPages> pages, Map<String, Object> additionalProperties) {
        this.type = type;
        this.conversations = conversations;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="conversations")
    public Optional<List<Conversation>> getConversations() {
        return this.conversations;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationList && this.equalTo((ConversationList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationList other) {
        return this.type.equals(other.type) && this.conversations.equals(other.conversations) && this.totalCount.equals(other.totalCount) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.conversations, this.totalCount, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Conversation>> conversations = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<CursorPages> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationList other) {
            this.type(other.getType());
            this.conversations(other.getConversations());
            this.totalCount(other.getTotalCount());
            this.pages(other.getPages());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="conversations", nulls=Nulls.SKIP)
        public Builder conversations(Optional<List<Conversation>> conversations) {
            this.conversations = conversations;
            return this;
        }

        public Builder conversations(List<Conversation> conversations) {
            this.conversations = Optional.ofNullable(conversations);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public ConversationList build() {
            return new ConversationList(this.type, this.conversations, this.totalCount, this.pages, this.additionalProperties);
        }
    }
}

