/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationPartAuthor {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> email;
    private final Optional<Boolean> fromAiAgent;
    private final Optional<Boolean> isAiAnswer;
    private final Map<String, Object> additionalProperties;

    private ConversationPartAuthor(Optional<String> type, Optional<String> id, Optional<String> name, Optional<String> email, Optional<Boolean> fromAiAgent, Optional<Boolean> isAiAnswer, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.fromAiAgent = fromAiAgent;
        this.isAiAnswer = isAiAnswer;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="from_ai_agent")
    public Optional<Boolean> getFromAiAgent() {
        return this.fromAiAgent;
    }

    @JsonProperty(value="is_ai_answer")
    public Optional<Boolean> getIsAiAnswer() {
        return this.isAiAnswer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationPartAuthor && this.equalTo((ConversationPartAuthor)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPartAuthor other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.email.equals(other.email) && this.fromAiAgent.equals(other.fromAiAgent) && this.isAiAnswer.equals(other.isAiAnswer);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email, this.fromAiAgent, this.isAiAnswer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<Boolean> fromAiAgent = Optional.empty();
        private Optional<Boolean> isAiAnswer = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationPartAuthor other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.email(other.getEmail());
            this.fromAiAgent(other.getFromAiAgent());
            this.isAiAnswer(other.getIsAiAnswer());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonSetter(value="from_ai_agent", nulls=Nulls.SKIP)
        public Builder fromAiAgent(Optional<Boolean> fromAiAgent) {
            this.fromAiAgent = fromAiAgent;
            return this;
        }

        public Builder fromAiAgent(Boolean fromAiAgent) {
            this.fromAiAgent = Optional.ofNullable(fromAiAgent);
            return this;
        }

        @JsonSetter(value="is_ai_answer", nulls=Nulls.SKIP)
        public Builder isAiAnswer(Optional<Boolean> isAiAnswer) {
            this.isAiAnswer = isAiAnswer;
            return this;
        }

        public Builder isAiAnswer(Boolean isAiAnswer) {
            this.isAiAnswer = Optional.ofNullable(isAiAnswer);
            return this;
        }

        public ConversationPartAuthor build() {
            return new ConversationPartAuthor(this.type, this.id, this.name, this.email, this.fromAiAgent, this.isAiAnswer, this.additionalProperties);
        }
    }
}

