/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.IQuickReplyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationPartMetadata {
    private final Optional<List<QuickReplyOptionsItem>> quickReplyOptions;
    private final Optional<String> quickReplyUuid;
    private final Map<String, Object> additionalProperties;

    private ConversationPartMetadata(Optional<List<QuickReplyOptionsItem>> quickReplyOptions, Optional<String> quickReplyUuid, Map<String, Object> additionalProperties) {
        this.quickReplyOptions = quickReplyOptions;
        this.quickReplyUuid = quickReplyUuid;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="quick_reply_options")
    public Optional<List<QuickReplyOptionsItem>> getQuickReplyOptions() {
        return this.quickReplyOptions;
    }

    @JsonProperty(value="quick_reply_uuid")
    public Optional<String> getQuickReplyUuid() {
        return this.quickReplyUuid;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationPartMetadata && this.equalTo((ConversationPartMetadata)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPartMetadata other) {
        return this.quickReplyOptions.equals(other.quickReplyOptions) && this.quickReplyUuid.equals(other.quickReplyUuid);
    }

    public int hashCode() {
        return Objects.hash(this.quickReplyOptions, this.quickReplyUuid);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class QuickReplyOptionsItem
    implements IQuickReplyOption {
        private final String text;
        private final String uuid;
        private final Optional<Map<String, Object>> translations;
        private final Map<String, Object> additionalProperties;

        private QuickReplyOptionsItem(String text, String uuid, Optional<Map<String, Object>> translations, Map<String, Object> additionalProperties) {
            this.text = text;
            this.uuid = uuid;
            this.translations = translations;
            this.additionalProperties = additionalProperties;
        }

        @Override
        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @Override
        @JsonProperty(value="uuid")
        public String getUuid() {
            return this.uuid;
        }

        @JsonProperty(value="translations")
        public Optional<Map<String, Object>> getTranslations() {
            return this.translations;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof QuickReplyOptionsItem && this.equalTo((QuickReplyOptionsItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(QuickReplyOptionsItem other) {
            return this.text.equals(other.text) && this.uuid.equals(other.uuid) && this.translations.equals(other.translations);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.uuid, this.translations);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static TextStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements TextStage,
        UuidStage,
        _FinalStage {
            private String text;
            private String uuid;
            private Optional<Map<String, Object>> translations = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(QuickReplyOptionsItem other) {
                this.text(other.getText());
                this.uuid(other.getUuid());
                this.translations(other.getTranslations());
                return this;
            }

            @Override
            @JsonSetter(value="text")
            public UuidStage text(@NotNull String text) {
                this.text = Objects.requireNonNull(text, "text must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="uuid")
            public _FinalStage uuid(@NotNull String uuid) {
                this.uuid = Objects.requireNonNull(uuid, "uuid must not be null");
                return this;
            }

            @Override
            public _FinalStage translations(Map<String, Object> translations) {
                this.translations = Optional.ofNullable(translations);
                return this;
            }

            @Override
            @JsonSetter(value="translations", nulls=Nulls.SKIP)
            public _FinalStage translations(Optional<Map<String, Object>> translations) {
                this.translations = translations;
                return this;
            }

            @Override
            public QuickReplyOptionsItem build() {
                return new QuickReplyOptionsItem(this.text, this.uuid, this.translations, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public QuickReplyOptionsItem build();

            public _FinalStage translations(Optional<Map<String, Object>> var1);

            public _FinalStage translations(Map<String, Object> var1);
        }

        public static interface UuidStage {
            public _FinalStage uuid(@NotNull String var1);
        }

        public static interface TextStage {
            public UuidStage text(@NotNull String var1);

            public Builder from(QuickReplyOptionsItem var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<QuickReplyOptionsItem>> quickReplyOptions = Optional.empty();
        private Optional<String> quickReplyUuid = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationPartMetadata other) {
            this.quickReplyOptions(other.getQuickReplyOptions());
            this.quickReplyUuid(other.getQuickReplyUuid());
            return this;
        }

        @JsonSetter(value="quick_reply_options", nulls=Nulls.SKIP)
        public Builder quickReplyOptions(Optional<List<QuickReplyOptionsItem>> quickReplyOptions) {
            this.quickReplyOptions = quickReplyOptions;
            return this;
        }

        public Builder quickReplyOptions(List<QuickReplyOptionsItem> quickReplyOptions) {
            this.quickReplyOptions = Optional.ofNullable(quickReplyOptions);
            return this;
        }

        @JsonSetter(value="quick_reply_uuid", nulls=Nulls.SKIP)
        public Builder quickReplyUuid(Optional<String> quickReplyUuid) {
            this.quickReplyUuid = quickReplyUuid;
            return this;
        }

        public Builder quickReplyUuid(String quickReplyUuid) {
            this.quickReplyUuid = Optional.ofNullable(quickReplyUuid);
            return this;
        }

        public ConversationPartMetadata build() {
            return new ConversationPartMetadata(this.quickReplyOptions, this.quickReplyUuid, this.additionalProperties);
        }
    }
}

