/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.DataEventSummaryItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataEventSummary {
    private final Optional<String> type;
    private final Optional<String> email;
    private final Optional<String> intercomUserId;
    private final Optional<String> userId;
    private final List<Optional<DataEventSummaryItem>> events;
    private final Map<String, Object> additionalProperties;

    private DataEventSummary(Optional<String> type, Optional<String> email, Optional<String> intercomUserId, Optional<String> userId, List<Optional<DataEventSummaryItem>> events, Map<String, Object> additionalProperties) {
        this.type = type;
        this.email = email;
        this.intercomUserId = intercomUserId;
        this.userId = userId;
        this.events = events;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="intercom_user_id")
    public Optional<String> getIntercomUserId() {
        return this.intercomUserId;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="events")
    public List<Optional<DataEventSummaryItem>> getEvents() {
        return this.events;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataEventSummary && this.equalTo((DataEventSummary)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventSummary other) {
        return this.type.equals(other.type) && this.email.equals(other.email) && this.intercomUserId.equals(other.intercomUserId) && this.userId.equals(other.userId) && this.events.equals(other.events);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.email, this.intercomUserId, this.userId, this.events);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> intercomUserId = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private List<Optional<DataEventSummaryItem>> events = new ArrayList<Optional<DataEventSummaryItem>>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DataEventSummary other) {
            this.type(other.getType());
            this.email(other.getEmail());
            this.intercomUserId(other.getIntercomUserId());
            this.userId(other.getUserId());
            this.events(other.getEvents());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonSetter(value="intercom_user_id", nulls=Nulls.SKIP)
        public Builder intercomUserId(Optional<String> intercomUserId) {
            this.intercomUserId = intercomUserId;
            return this;
        }

        public Builder intercomUserId(String intercomUserId) {
            this.intercomUserId = Optional.ofNullable(intercomUserId);
            return this;
        }

        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public Builder events(List<Optional<DataEventSummaryItem>> events) {
            this.events.clear();
            if (events != null) {
                this.events.addAll(events);
            }
            return this;
        }

        public Builder addEvents(Optional<DataEventSummaryItem> events) {
            this.events.add(events);
            return this;
        }

        public Builder addAllEvents(List<Optional<DataEventSummaryItem>> events) {
            if (events != null) {
                this.events.addAll(events);
            }
            return this;
        }

        public DataEventSummary build() {
            return new DataEventSummary(this.type, this.email, this.intercomUserId, this.userId, this.events, this.additionalProperties);
        }
    }
}

