/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Error {
    private final Optional<String> requestId;
    private final List<ErrorsItem> errors;
    private final Map<String, Object> additionalProperties;

    private Error(Optional<String> requestId, List<ErrorsItem> errors, Map<String, Object> additionalProperties) {
        this.requestId = requestId;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "error.list";
    }

    @JsonProperty(value="request_id")
    public Optional<String> getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="errors")
    public List<ErrorsItem> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Error && this.equalTo((Error)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Error other) {
        return this.requestId.equals(other.requestId) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class ErrorsItem {
        private final String code;
        private final Optional<String> message;
        private final Optional<String> field;
        private final Map<String, Object> additionalProperties;

        private ErrorsItem(String code, Optional<String> message, Optional<String> field, Map<String, Object> additionalProperties) {
            this.code = code;
            this.message = message;
            this.field = field;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="code")
        public String getCode() {
            return this.code;
        }

        @JsonProperty(value="message")
        public Optional<String> getMessage() {
            return this.message;
        }

        @JsonProperty(value="field")
        public Optional<String> getField() {
            return this.field;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ErrorsItem && this.equalTo((ErrorsItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ErrorsItem other) {
            return this.code.equals(other.code) && this.message.equals(other.message) && this.field.equals(other.field);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.message, this.field);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static CodeStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements CodeStage,
        _FinalStage {
            private String code;
            private Optional<String> field = Optional.empty();
            private Optional<String> message = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(ErrorsItem other) {
                this.code(other.getCode());
                this.message(other.getMessage());
                this.field(other.getField());
                return this;
            }

            @Override
            @JsonSetter(value="code")
            public _FinalStage code(@NotNull String code) {
                this.code = Objects.requireNonNull(code, "code must not be null");
                return this;
            }

            @Override
            public _FinalStage field(String field) {
                this.field = Optional.ofNullable(field);
                return this;
            }

            @Override
            @JsonSetter(value="field", nulls=Nulls.SKIP)
            public _FinalStage field(Optional<String> field) {
                this.field = field;
                return this;
            }

            @Override
            public _FinalStage message(String message) {
                this.message = Optional.ofNullable(message);
                return this;
            }

            @Override
            @JsonSetter(value="message", nulls=Nulls.SKIP)
            public _FinalStage message(Optional<String> message) {
                this.message = message;
                return this;
            }

            @Override
            public ErrorsItem build() {
                return new ErrorsItem(this.code, this.message, this.field, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public ErrorsItem build();

            public _FinalStage message(Optional<String> var1);

            public _FinalStage message(String var1);

            public _FinalStage field(Optional<String> var1);

            public _FinalStage field(String var1);
        }

        public static interface CodeStage {
            public _FinalStage code(@NotNull String var1);

            public Builder from(ErrorsItem var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> requestId = Optional.empty();
        private List<ErrorsItem> errors = new ArrayList<ErrorsItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Error other) {
            this.requestId(other.getRequestId());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="request_id", nulls=Nulls.SKIP)
        public Builder requestId(Optional<String> requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder requestId(String requestId) {
            this.requestId = Optional.ofNullable(requestId);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(List<ErrorsItem> errors) {
            this.errors.clear();
            if (errors != null) {
                this.errors.addAll(errors);
            }
            return this;
        }

        public Builder addErrors(ErrorsItem errors) {
            this.errors.add(errors);
            return this;
        }

        public Builder addAllErrors(List<ErrorsItem> errors) {
            if (errors != null) {
                this.errors.addAll(errors);
            }
            return this;
        }

        public Error build() {
            return new Error(this.requestId, this.errors, this.additionalProperties);
        }
    }
}

