/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TagMultipleUsersRequest {
    private final String name;
    private final List<UsersItem> users;
    private final Map<String, Object> additionalProperties;

    private TagMultipleUsersRequest(String name, List<UsersItem> users, Map<String, Object> additionalProperties) {
        this.name = name;
        this.users = users;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="users")
    public List<UsersItem> getUsers() {
        return this.users;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TagMultipleUsersRequest && this.equalTo((TagMultipleUsersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TagMultipleUsersRequest other) {
        return this.name.equals(other.name) && this.users.equals(other.users);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.users);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class UsersItem {
        private final Optional<String> id;
        private final Map<String, Object> additionalProperties;

        private UsersItem(Optional<String> id, Map<String, Object> additionalProperties) {
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="id")
        public Optional<String> getId() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UsersItem && this.equalTo((UsersItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(UsersItem other) {
            return this.id.equals(other.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> id = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(UsersItem other) {
                this.id(other.getId());
                return this;
            }

            @JsonSetter(value="id", nulls=Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            public UsersItem build() {
                return new UsersItem(this.id, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private List<UsersItem> users = new ArrayList<UsersItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TagMultipleUsersRequest other) {
            this.name(other.getName());
            this.users(other.getUsers());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllUsers(List<UsersItem> users) {
            if (users != null) {
                this.users.addAll(users);
            }
            return this;
        }

        @Override
        public _FinalStage addUsers(UsersItem users) {
            this.users.add(users);
            return this;
        }

        @Override
        @JsonSetter(value="users", nulls=Nulls.SKIP)
        public _FinalStage users(List<UsersItem> users) {
            this.users.clear();
            if (users != null) {
                this.users.addAll(users);
            }
            return this;
        }

        @Override
        public TagMultipleUsersRequest build() {
            return new TagMultipleUsersRequest(this.name, this.users, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TagMultipleUsersRequest build();

        public _FinalStage users(List<UsersItem> var1);

        public _FinalStage addUsers(UsersItem var1);

        public _FinalStage addAllUsers(List<UsersItem> var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(TagMultipleUsersRequest var1);
    }
}

