/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketTypeAttribute {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> workspaceId;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<DataType> dataType;
    private final Optional<Map<String, Object>> inputOptions;
    private final Optional<Integer> order;
    private final Optional<Boolean> requiredToCreate;
    private final Optional<Boolean> requiredToCreateForContacts;
    private final Optional<Boolean> visibleOnCreate;
    private final Optional<Boolean> visibleToContacts;
    private final Optional<Boolean> default_;
    private final Optional<Integer> ticketTypeId;
    private final Optional<Boolean> archived;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Map<String, Object> additionalProperties;

    private TicketTypeAttribute(Optional<String> type, Optional<String> id, Optional<String> workspaceId, Optional<String> name, Optional<String> description, Optional<DataType> dataType, Optional<Map<String, Object>> inputOptions, Optional<Integer> order, Optional<Boolean> requiredToCreate, Optional<Boolean> requiredToCreateForContacts, Optional<Boolean> visibleOnCreate, Optional<Boolean> visibleToContacts, Optional<Boolean> default_, Optional<Integer> ticketTypeId, Optional<Boolean> archived, Optional<Integer> createdAt, Optional<Integer> updatedAt, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.inputOptions = inputOptions;
        this.order = order;
        this.requiredToCreate = requiredToCreate;
        this.requiredToCreateForContacts = requiredToCreateForContacts;
        this.visibleOnCreate = visibleOnCreate;
        this.visibleToContacts = visibleToContacts;
        this.default_ = default_;
        this.ticketTypeId = ticketTypeId;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public Optional<String> getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="data_type")
    public Optional<DataType> getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="input_options")
    public Optional<Map<String, Object>> getInputOptions() {
        return this.inputOptions;
    }

    @JsonProperty(value="order")
    public Optional<Integer> getOrder() {
        return this.order;
    }

    @JsonProperty(value="required_to_create")
    public Optional<Boolean> getRequiredToCreate() {
        return this.requiredToCreate;
    }

    @JsonProperty(value="required_to_create_for_contacts")
    public Optional<Boolean> getRequiredToCreateForContacts() {
        return this.requiredToCreateForContacts;
    }

    @JsonProperty(value="visible_on_create")
    public Optional<Boolean> getVisibleOnCreate() {
        return this.visibleOnCreate;
    }

    @JsonProperty(value="visible_to_contacts")
    public Optional<Boolean> getVisibleToContacts() {
        return this.visibleToContacts;
    }

    @JsonProperty(value="default")
    public Optional<Boolean> getDefault() {
        return this.default_;
    }

    @JsonProperty(value="ticket_type_id")
    public Optional<Integer> getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketTypeAttribute && this.equalTo((TicketTypeAttribute)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketTypeAttribute other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.name.equals(other.name) && this.description.equals(other.description) && this.dataType.equals(other.dataType) && this.inputOptions.equals(other.inputOptions) && this.order.equals(other.order) && this.requiredToCreate.equals(other.requiredToCreate) && this.requiredToCreateForContacts.equals(other.requiredToCreateForContacts) && this.visibleOnCreate.equals(other.visibleOnCreate) && this.visibleToContacts.equals(other.visibleToContacts) && this.default_.equals(other.default_) && this.ticketTypeId.equals(other.ticketTypeId) && this.archived.equals(other.archived) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.workspaceId, this.name, this.description, this.dataType, this.inputOptions, this.order, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.default_, this.ticketTypeId, this.archived, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");
        public static final DataType DECIMAL = new DataType(Value.DECIMAL, "decimal");
        public static final DataType LIST = new DataType(Value.LIST, "list");
        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");
        public static final DataType DATETIME = new DataType(Value.DATETIME, "datetime");
        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");
        public static final DataType FILES = new DataType(Value.FILES, "files");
        private final Value value;
        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DataType && this.string.equals(((DataType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case STRING: {
                    return visitor.visitString();
                }
                case DECIMAL: {
                    return visitor.visitDecimal();
                }
                case LIST: {
                    return visitor.visitList();
                }
                case INTEGER: {
                    return visitor.visitInteger();
                }
                case DATETIME: {
                    return visitor.visitDatetime();
                }
                case BOOLEAN: {
                    return visitor.visitBoolean();
                }
                case FILES: {
                    return visitor.visitFiles();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string": {
                    return STRING;
                }
                case "decimal": {
                    return DECIMAL;
                }
                case "list": {
                    return LIST;
                }
                case "integer": {
                    return INTEGER;
                }
                case "datetime": {
                    return DATETIME;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "files": {
                    return FILES;
                }
            }
            return new DataType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitString();

            public T visitList();

            public T visitInteger();

            public T visitDecimal();

            public T visitBoolean();

            public T visitDatetime();

            public T visitFiles();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            STRING,
            LIST,
            INTEGER,
            DECIMAL,
            BOOLEAN,
            DATETIME,
            FILES,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> workspaceId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<DataType> dataType = Optional.empty();
        private Optional<Map<String, Object>> inputOptions = Optional.empty();
        private Optional<Integer> order = Optional.empty();
        private Optional<Boolean> requiredToCreate = Optional.empty();
        private Optional<Boolean> requiredToCreateForContacts = Optional.empty();
        private Optional<Boolean> visibleOnCreate = Optional.empty();
        private Optional<Boolean> visibleToContacts = Optional.empty();
        private Optional<Boolean> default_ = Optional.empty();
        private Optional<Integer> ticketTypeId = Optional.empty();
        private Optional<Boolean> archived = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TicketTypeAttribute other) {
            this.type(other.getType());
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.dataType(other.getDataType());
            this.inputOptions(other.getInputOptions());
            this.order(other.getOrder());
            this.requiredToCreate(other.getRequiredToCreate());
            this.requiredToCreateForContacts(other.getRequiredToCreateForContacts());
            this.visibleOnCreate(other.getVisibleOnCreate());
            this.visibleToContacts(other.getVisibleToContacts());
            this.default_(other.getDefault());
            this.ticketTypeId(other.getTicketTypeId());
            this.archived(other.getArchived());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="workspace_id", nulls=Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="data_type", nulls=Nulls.SKIP)
        public Builder dataType(Optional<DataType> dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataType(DataType dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        @JsonSetter(value="input_options", nulls=Nulls.SKIP)
        public Builder inputOptions(Optional<Map<String, Object>> inputOptions) {
            this.inputOptions = inputOptions;
            return this;
        }

        public Builder inputOptions(Map<String, Object> inputOptions) {
            this.inputOptions = Optional.ofNullable(inputOptions);
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<Integer> order) {
            this.order = order;
            return this;
        }

        public Builder order(Integer order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @JsonSetter(value="required_to_create", nulls=Nulls.SKIP)
        public Builder requiredToCreate(Optional<Boolean> requiredToCreate) {
            this.requiredToCreate = requiredToCreate;
            return this;
        }

        public Builder requiredToCreate(Boolean requiredToCreate) {
            this.requiredToCreate = Optional.ofNullable(requiredToCreate);
            return this;
        }

        @JsonSetter(value="required_to_create_for_contacts", nulls=Nulls.SKIP)
        public Builder requiredToCreateForContacts(Optional<Boolean> requiredToCreateForContacts) {
            this.requiredToCreateForContacts = requiredToCreateForContacts;
            return this;
        }

        public Builder requiredToCreateForContacts(Boolean requiredToCreateForContacts) {
            this.requiredToCreateForContacts = Optional.ofNullable(requiredToCreateForContacts);
            return this;
        }

        @JsonSetter(value="visible_on_create", nulls=Nulls.SKIP)
        public Builder visibleOnCreate(Optional<Boolean> visibleOnCreate) {
            this.visibleOnCreate = visibleOnCreate;
            return this;
        }

        public Builder visibleOnCreate(Boolean visibleOnCreate) {
            this.visibleOnCreate = Optional.ofNullable(visibleOnCreate);
            return this;
        }

        @JsonSetter(value="visible_to_contacts", nulls=Nulls.SKIP)
        public Builder visibleToContacts(Optional<Boolean> visibleToContacts) {
            this.visibleToContacts = visibleToContacts;
            return this;
        }

        public Builder visibleToContacts(Boolean visibleToContacts) {
            this.visibleToContacts = Optional.ofNullable(visibleToContacts);
            return this;
        }

        @JsonSetter(value="default", nulls=Nulls.SKIP)
        public Builder default_(Optional<Boolean> default_) {
            this.default_ = default_;
            return this;
        }

        public Builder default_(Boolean default_) {
            this.default_ = Optional.ofNullable(default_);
            return this;
        }

        @JsonSetter(value="ticket_type_id", nulls=Nulls.SKIP)
        public Builder ticketTypeId(Optional<Integer> ticketTypeId) {
            this.ticketTypeId = ticketTypeId;
            return this;
        }

        public Builder ticketTypeId(Integer ticketTypeId) {
            this.ticketTypeId = Optional.ofNullable(ticketTypeId);
            return this;
        }

        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public TicketTypeAttribute build() {
            return new TicketTypeAttribute(this.type, this.id, this.workspaceId, this.name, this.description, this.dataType, this.inputOptions, this.order, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.default_, this.ticketTypeId, this.archived, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

