/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class WhatsappMessageStatusList {
    private final String rulesetId;
    private final Pages pages;
    private final int totalCount;
    private final List<EventsItem> events;
    private final Map<String, Object> additionalProperties;

    private WhatsappMessageStatusList(String rulesetId, Pages pages, int totalCount, List<EventsItem> events, Map<String, Object> additionalProperties) {
        this.rulesetId = rulesetId;
        this.pages = pages;
        this.totalCount = totalCount;
        this.events = events;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "list";
    }

    @JsonProperty(value="ruleset_id")
    public String getRulesetId() {
        return this.rulesetId;
    }

    @JsonProperty(value="pages")
    public Pages getPages() {
        return this.pages;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="events")
    public List<EventsItem> getEvents() {
        return this.events;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WhatsappMessageStatusList && this.equalTo((WhatsappMessageStatusList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WhatsappMessageStatusList other) {
        return this.rulesetId.equals(other.rulesetId) && this.pages.equals(other.pages) && this.totalCount == other.totalCount && this.events.equals(other.events);
    }

    public int hashCode() {
        return Objects.hash(this.rulesetId, this.pages, this.totalCount, this.events);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RulesetIdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class EventsItem {
        private final String id;
        private final String conversationId;
        private final Status status;
        private final int createdAt;
        private final int updatedAt;
        private final String whatsappMessageId;
        private final Optional<String> templateName;
        private final Map<String, Object> additionalProperties;

        private EventsItem(String id, String conversationId, Status status, int createdAt, int updatedAt, String whatsappMessageId, Optional<String> templateName, Map<String, Object> additionalProperties) {
            this.id = id;
            this.conversationId = conversationId;
            this.status = status;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.whatsappMessageId = whatsappMessageId;
            this.templateName = templateName;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="id")
        public String getId() {
            return this.id;
        }

        @JsonProperty(value="conversation_id")
        public String getConversationId() {
            return this.conversationId;
        }

        @JsonProperty(value="status")
        public Status getStatus() {
            return this.status;
        }

        @JsonProperty(value="type")
        public String getType() {
            return "broadcast_outbound";
        }

        @JsonProperty(value="created_at")
        public int getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="updated_at")
        public int getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="whatsapp_message_id")
        public String getWhatsappMessageId() {
            return this.whatsappMessageId;
        }

        @JsonProperty(value="template_name")
        public Optional<String> getTemplateName() {
            return this.templateName;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof EventsItem && this.equalTo((EventsItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(EventsItem other) {
            return this.id.equals(other.id) && this.conversationId.equals(other.conversationId) && this.status.equals(other.status) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.whatsappMessageId.equals(other.whatsappMessageId) && this.templateName.equals(other.templateName);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.conversationId, this.status, this.createdAt, this.updatedAt, this.whatsappMessageId, this.templateName);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IdStage builder() {
            return new Builder();
        }

        public static final class Status {
            public static final Status DELIVERED = new Status(Value.DELIVERED, "delivered");
            public static final Status FAILED = new Status(Value.FAILED, "failed");
            public static final Status READ = new Status(Value.READ, "read");
            public static final Status SENT = new Status(Value.SENT, "sent");
            private final Value value;
            private final String string;

            Status(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return this.value;
            }

            @JsonValue
            public String toString() {
                return this.string;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof Status && this.string.equals(((Status)other).string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (this.value) {
                    case DELIVERED: {
                        return visitor.visitDelivered();
                    }
                    case FAILED: {
                        return visitor.visitFailed();
                    }
                    case READ: {
                        return visitor.visitRead();
                    }
                    case SENT: {
                        return visitor.visitSent();
                    }
                }
                return visitor.visitUnknown(this.string);
            }

            @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
            public static Status valueOf(String value) {
                switch (value) {
                    case "delivered": {
                        return DELIVERED;
                    }
                    case "failed": {
                        return FAILED;
                    }
                    case "read": {
                        return READ;
                    }
                    case "sent": {
                        return SENT;
                    }
                }
                return new Status(Value.UNKNOWN, value);
            }

            public static interface Visitor<T> {
                public T visitSent();

                public T visitDelivered();

                public T visitRead();

                public T visitFailed();

                public T visitUnknown(String var1);
            }

            public static enum Value {
                SENT,
                DELIVERED,
                READ,
                FAILED,
                UNKNOWN;

            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements IdStage,
        ConversationIdStage,
        StatusStage,
        CreatedAtStage,
        UpdatedAtStage,
        WhatsappMessageIdStage,
        _FinalStage {
            private String id;
            private String conversationId;
            private Status status;
            private int createdAt;
            private int updatedAt;
            private String whatsappMessageId;
            private Optional<String> templateName = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(EventsItem other) {
                this.id(other.getId());
                this.conversationId(other.getConversationId());
                this.status(other.getStatus());
                this.createdAt(other.getCreatedAt());
                this.updatedAt(other.getUpdatedAt());
                this.whatsappMessageId(other.getWhatsappMessageId());
                this.templateName(other.getTemplateName());
                return this;
            }

            @Override
            @JsonSetter(value="id")
            public ConversationIdStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="conversation_id")
            public StatusStage conversationId(@NotNull String conversationId) {
                this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="status")
            public CreatedAtStage status(@NotNull Status status) {
                this.status = Objects.requireNonNull(status, "status must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="created_at")
            public UpdatedAtStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Override
            @JsonSetter(value="updated_at")
            public WhatsappMessageIdStage updatedAt(int updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            @Override
            @JsonSetter(value="whatsapp_message_id")
            public _FinalStage whatsappMessageId(@NotNull String whatsappMessageId) {
                this.whatsappMessageId = Objects.requireNonNull(whatsappMessageId, "whatsappMessageId must not be null");
                return this;
            }

            @Override
            public _FinalStage templateName(String templateName) {
                this.templateName = Optional.ofNullable(templateName);
                return this;
            }

            @Override
            @JsonSetter(value="template_name", nulls=Nulls.SKIP)
            public _FinalStage templateName(Optional<String> templateName) {
                this.templateName = templateName;
                return this;
            }

            @Override
            public EventsItem build() {
                return new EventsItem(this.id, this.conversationId, this.status, this.createdAt, this.updatedAt, this.whatsappMessageId, this.templateName, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public EventsItem build();

            public _FinalStage templateName(Optional<String> var1);

            public _FinalStage templateName(String var1);
        }

        public static interface WhatsappMessageIdStage {
            public _FinalStage whatsappMessageId(@NotNull String var1);
        }

        public static interface UpdatedAtStage {
            public WhatsappMessageIdStage updatedAt(int var1);
        }

        public static interface CreatedAtStage {
            public UpdatedAtStage createdAt(int var1);
        }

        public static interface StatusStage {
            public CreatedAtStage status(@NotNull Status var1);
        }

        public static interface ConversationIdStage {
            public StatusStage conversationId(@NotNull String var1);
        }

        public static interface IdStage {
            public ConversationIdStage id(@NotNull String var1);

            public Builder from(EventsItem var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Pages {
        private final int perPage;
        private final int totalPages;
        private final Optional<Next> next;
        private final Map<String, Object> additionalProperties;

        private Pages(int perPage, int totalPages, Optional<Next> next, Map<String, Object> additionalProperties) {
            this.perPage = perPage;
            this.totalPages = totalPages;
            this.next = next;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public String getType() {
            return "pages";
        }

        @JsonProperty(value="per_page")
        public int getPerPage() {
            return this.perPage;
        }

        @JsonProperty(value="total_pages")
        public int getTotalPages() {
            return this.totalPages;
        }

        @JsonProperty(value="next")
        public Optional<Next> getNext() {
            return this.next;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Pages && this.equalTo((Pages)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Pages other) {
            return this.perPage == other.perPage && this.totalPages == other.totalPages && this.next.equals(other.next);
        }

        public int hashCode() {
            return Objects.hash(this.perPage, this.totalPages, this.next);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static PerPageStage builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class Next {
            private final Optional<String> startingAfter;
            private final Map<String, Object> additionalProperties;

            private Next(Optional<String> startingAfter, Map<String, Object> additionalProperties) {
                this.startingAfter = startingAfter;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="starting_after")
            public Optional<String> getStartingAfter() {
                return this.startingAfter;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof Next && this.equalTo((Next)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Next other) {
                return this.startingAfter.equals(other.startingAfter);
            }

            public int hashCode() {
                return Objects.hash(this.startingAfter);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder {
                private Optional<String> startingAfter = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                public Builder from(Next other) {
                    this.startingAfter(other.getStartingAfter());
                    return this;
                }

                @JsonSetter(value="starting_after", nulls=Nulls.SKIP)
                public Builder startingAfter(Optional<String> startingAfter) {
                    this.startingAfter = startingAfter;
                    return this;
                }

                public Builder startingAfter(String startingAfter) {
                    this.startingAfter = Optional.ofNullable(startingAfter);
                    return this;
                }

                public Next build() {
                    return new Next(this.startingAfter, this.additionalProperties);
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements PerPageStage,
        TotalPagesStage,
        _FinalStage {
            private int perPage;
            private int totalPages;
            private Optional<Next> next = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Pages other) {
                this.perPage(other.getPerPage());
                this.totalPages(other.getTotalPages());
                this.next(other.getNext());
                return this;
            }

            @Override
            @JsonSetter(value="per_page")
            public TotalPagesStage perPage(int perPage) {
                this.perPage = perPage;
                return this;
            }

            @Override
            @JsonSetter(value="total_pages")
            public _FinalStage totalPages(int totalPages) {
                this.totalPages = totalPages;
                return this;
            }

            @Override
            public _FinalStage next(Next next) {
                this.next = Optional.ofNullable(next);
                return this;
            }

            @Override
            @JsonSetter(value="next", nulls=Nulls.SKIP)
            public _FinalStage next(Optional<Next> next) {
                this.next = next;
                return this;
            }

            @Override
            public Pages build() {
                return new Pages(this.perPage, this.totalPages, this.next, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Pages build();

            public _FinalStage next(Optional<Next> var1);

            public _FinalStage next(Next var1);
        }

        public static interface TotalPagesStage {
            public _FinalStage totalPages(int var1);
        }

        public static interface PerPageStage {
            public TotalPagesStage perPage(int var1);

            public Builder from(Pages var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RulesetIdStage,
    PagesStage,
    TotalCountStage,
    _FinalStage {
        private String rulesetId;
        private Pages pages;
        private int totalCount;
        private List<EventsItem> events = new ArrayList<EventsItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WhatsappMessageStatusList other) {
            this.rulesetId(other.getRulesetId());
            this.pages(other.getPages());
            this.totalCount(other.getTotalCount());
            this.events(other.getEvents());
            return this;
        }

        @Override
        @JsonSetter(value="ruleset_id")
        public PagesStage rulesetId(@NotNull String rulesetId) {
            this.rulesetId = Objects.requireNonNull(rulesetId, "rulesetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="pages")
        public TotalCountStage pages(@NotNull Pages pages) {
            this.pages = Objects.requireNonNull(pages, "pages must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllEvents(List<EventsItem> events) {
            if (events != null) {
                this.events.addAll(events);
            }
            return this;
        }

        @Override
        public _FinalStage addEvents(EventsItem events) {
            this.events.add(events);
            return this;
        }

        @Override
        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public _FinalStage events(List<EventsItem> events) {
            this.events.clear();
            if (events != null) {
                this.events.addAll(events);
            }
            return this;
        }

        @Override
        public WhatsappMessageStatusList build() {
            return new WhatsappMessageStatusList(this.rulesetId, this.pages, this.totalCount, this.events, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WhatsappMessageStatusList build();

        public _FinalStage events(List<EventsItem> var1);

        public _FinalStage addEvents(EventsItem var1);

        public _FinalStage addAllEvents(List<EventsItem> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);
    }

    public static interface PagesStage {
        public TotalCountStage pages(@NotNull Pages var1);
    }

    public static interface RulesetIdStage {
        public PagesStage rulesetId(@NotNull String var1);

        public Builder from(WhatsappMessageStatusList var1);
    }
}

