/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SearchArticlesRequest.Builder.class)
public final class SearchArticlesRequest {
    private final Optional<String> phrase;

    private final Optional<String> state;

    private final Optional<Integer> helpCenterId;

    private final Optional<Boolean> highlight;

    private final Map<String, Object> additionalProperties;

    private SearchArticlesRequest(
            Optional<String> phrase,
            Optional<String> state,
            Optional<Integer> helpCenterId,
            Optional<Boolean> highlight,
            Map<String, Object> additionalProperties) {
        this.phrase = phrase;
        this.state = state;
        this.helpCenterId = helpCenterId;
        this.highlight = highlight;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The phrase within your articles to search for.
     */
    @JsonProperty("phrase")
    public Optional<String> getPhrase() {
        return phrase;
    }

    /**
     * @return The state of the Articles returned. One of <code>published</code>, <code>draft</code> or <code>all</code>.
     */
    @JsonProperty("state")
    public Optional<String> getState() {
        return state;
    }

    /**
     * @return The ID of the Help Center to search in.
     */
    @JsonProperty("help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return helpCenterId;
    }

    /**
     * @return Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.
     */
    @JsonProperty("highlight")
    public Optional<Boolean> getHighlight() {
        return highlight;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SearchArticlesRequest && equalTo((SearchArticlesRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchArticlesRequest other) {
        return phrase.equals(other.phrase)
                && state.equals(other.state)
                && helpCenterId.equals(other.helpCenterId)
                && highlight.equals(other.highlight);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.phrase, this.state, this.helpCenterId, this.highlight);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> phrase = Optional.empty();

        private Optional<String> state = Optional.empty();

        private Optional<Integer> helpCenterId = Optional.empty();

        private Optional<Boolean> highlight = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SearchArticlesRequest other) {
            phrase(other.getPhrase());
            state(other.getState());
            helpCenterId(other.getHelpCenterId());
            highlight(other.getHighlight());
            return this;
        }

        /**
         * <p>The phrase within your articles to search for.</p>
         */
        @JsonSetter(value = "phrase", nulls = Nulls.SKIP)
        public Builder phrase(Optional<String> phrase) {
            this.phrase = phrase;
            return this;
        }

        public Builder phrase(String phrase) {
            this.phrase = Optional.ofNullable(phrase);
            return this;
        }

        /**
         * <p>The state of the Articles returned. One of <code>published</code>, <code>draft</code> or <code>all</code>.</p>
         */
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public Builder state(Optional<String> state) {
            this.state = state;
            return this;
        }

        public Builder state(String state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * <p>The ID of the Help Center to search in.</p>
         */
        @JsonSetter(value = "help_center_id", nulls = Nulls.SKIP)
        public Builder helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        public Builder helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        /**
         * <p>Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.</p>
         */
        @JsonSetter(value = "highlight", nulls = Nulls.SKIP)
        public Builder highlight(Optional<Boolean> highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = Optional.ofNullable(highlight);
            return this;
        }

        public SearchArticlesRequest build() {
            return new SearchArticlesRequest(phrase, state, helpCenterId, highlight, additionalProperties);
        }
    }
}
