/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.calls;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.calls.requests.ListCallsRequest;
import com.intercom.api.resources.calls.requests.ListCallsWithTranscriptsRequest;
import com.intercom.api.resources.calls.requests.ShowCallRecordingRequest;
import com.intercom.api.resources.calls.requests.ShowCallRequest;
import com.intercom.api.resources.calls.requests.ShowCallTranscriptRequest;
import com.intercom.api.resources.calls.types.Call;
import com.intercom.api.resources.calls.types.ListCallsWithTranscriptsResponse;
import com.intercom.api.types.CallList;
import java.util.concurrent.CompletableFuture;

public class AsyncCallsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCallsClient rawClient;

    public AsyncCallsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCallsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCallsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CompletableFuture<CallList> listCalls() {
        return this.rawClient.listCalls().thenApply(response -> response.body());
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CompletableFuture<CallList> listCalls(ListCallsRequest request) {
        return this.rawClient.listCalls(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CompletableFuture<CallList> listCalls(ListCallsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCalls(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieve a single call by id.
     */
    public CompletableFuture<Call> showCall(ShowCallRequest request) {
        return this.rawClient.showCall(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve a single call by id.
     */
    public CompletableFuture<Call> showCall(ShowCallRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCall(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request) {
        return this.rawClient.showCallRecording(request).thenApply(response -> response.body());
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallRecording(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public CompletableFuture<String> showCallTranscript(ShowCallTranscriptRequest request) {
        return this.rawClient.showCallTranscript(request).thenApply(response -> response.body());
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public CompletableFuture<String> showCallTranscript(
            ShowCallTranscriptRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallTranscript(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(
            ListCallsWithTranscriptsRequest request) {
        return this.rawClient.listCallsWithTranscripts(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(
            ListCallsWithTranscriptsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCallsWithTranscripts(request, requestOptions).thenApply(response -> response.body());
    }
}
