/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RetrieveCompanyRequest.Builder.class)
public final class RetrieveCompanyRequest {
    private final Optional<String> name;

    private final Optional<String> companyId;

    private final Optional<String> tagId;

    private final Optional<String> segmentId;

    private final Optional<Integer> page;

    private final Optional<Integer> perPage;

    private final Map<String, Object> additionalProperties;

    private RetrieveCompanyRequest(
            Optional<String> name,
            Optional<String> companyId,
            Optional<String> tagId,
            Optional<String> segmentId,
            Optional<Integer> page,
            Optional<Integer> perPage,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.companyId = companyId;
        this.tagId = tagId;
        this.segmentId = segmentId;
        this.page = page;
        this.perPage = perPage;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The <code>name</code> of the company to filter by.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The <code>company_id</code> of the company to filter by.
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return The <code>tag_id</code> of the company to filter by.
     */
    @JsonProperty("tag_id")
    public Optional<String> getTagId() {
        return tagId;
    }

    /**
     * @return The <code>segment_id</code> of the company to filter by.
     */
    @JsonProperty("segment_id")
    public Optional<String> getSegmentId() {
        return segmentId;
    }

    /**
     * @return The page of results to fetch. Defaults to first page
     */
    @JsonProperty("page")
    public Optional<Integer> getPage() {
        return page;
    }

    /**
     * @return How many results to display per page. Defaults to 15
     */
    @JsonProperty("per_page")
    public Optional<Integer> getPerPage() {
        return perPage;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RetrieveCompanyRequest && equalTo((RetrieveCompanyRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RetrieveCompanyRequest other) {
        return name.equals(other.name)
                && companyId.equals(other.companyId)
                && tagId.equals(other.tagId)
                && segmentId.equals(other.segmentId)
                && page.equals(other.page)
                && perPage.equals(other.perPage);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.companyId, this.tagId, this.segmentId, this.page, this.perPage);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Optional<String> tagId = Optional.empty();

        private Optional<String> segmentId = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<Integer> perPage = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(RetrieveCompanyRequest other) {
            name(other.getName());
            companyId(other.getCompanyId());
            tagId(other.getTagId());
            segmentId(other.getSegmentId());
            page(other.getPage());
            perPage(other.getPerPage());
            return this;
        }

        /**
         * <p>The <code>name</code> of the company to filter by.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The <code>company_id</code> of the company to filter by.</p>
         */
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        /**
         * <p>The <code>tag_id</code> of the company to filter by.</p>
         */
        @JsonSetter(value = "tag_id", nulls = Nulls.SKIP)
        public Builder tagId(Optional<String> tagId) {
            this.tagId = tagId;
            return this;
        }

        public Builder tagId(String tagId) {
            this.tagId = Optional.ofNullable(tagId);
            return this;
        }

        /**
         * <p>The <code>segment_id</code> of the company to filter by.</p>
         */
        @JsonSetter(value = "segment_id", nulls = Nulls.SKIP)
        public Builder segmentId(Optional<String> segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public Builder segmentId(String segmentId) {
            this.segmentId = Optional.ofNullable(segmentId);
            return this;
        }

        /**
         * <p>The page of results to fetch. Defaults to first page</p>
         */
        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        /**
         * <p>How many results to display per page. Defaults to 15</p>
         */
        @JsonSetter(value = "per_page", nulls = Nulls.SKIP)
        public Builder perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        public RetrieveCompanyRequest build() {
            return new RetrieveCompanyRequest(name, companyId, tagId, segmentId, page, perPage, additionalProperties);
        }
    }
}
